/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.layout;

import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.macro.BaseMacro;
import com.atlassian.renderer.v2.macro.MacroException;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class SectionMacro
extends BaseMacro {
    private static final String MACRO_NAME = "section";

    public boolean suppressSurroundingTagDuringWysiwygRendering() {
        return false;
    }

    public boolean suppressMacroRenderingDuringWysiwyg() {
        return true;
    }

    public String getName() {
        return MACRO_NAME;
    }

    public boolean isInline() {
        return false;
    }

    public boolean hasBody() {
        return true;
    }

    public RenderMode getBodyRenderMode() {
        return RenderMode.ALL;
    }

    public String execute(Map parameters, String body, RenderContext renderContext) throws MacroException {
        int firstDivIndex;
        String cssClass;
        String string = cssClass = Boolean.parseBoolean(StringUtils.defaultString((String)((String)parameters.get("border")))) ? " class=\"sectionMacroWithBorder\"" : " class=\"sectionMacro\"";
        if (renderContext.getOutputType().equals("preview")) {
            Pattern emptyParagraphPattern = Pattern.compile("</div><p>(&nbsp;|&#160;|\\s|\\u00a0|)</p>");
            body = emptyParagraphPattern.matcher(body).replaceAll("</div>");
        }
        if ((firstDivIndex = body.indexOf("<div")) > -1) {
            return "<div class=\"sectionColumnWrapper\"><div" + cssClass + ">" + body.substring(0, firstDivIndex) + "<div class=\"sectionMacroRow\">" + body.substring(firstDivIndex, body.length()) + "</div></div></div>";
        }
        return "<div" + cssClass + ">" + "<div class=\"sectionMacroRow\">" + body + "</div></div>";
    }
}

