/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.team;

import com.atlassian.confluence.api.model.web.WebItemView;
import com.atlassian.confluence.content.datasource.DataSource;
import com.atlassian.confluence.content.datasource.DataSourceFactory;
import com.atlassian.confluence.content.datasource.ResourceModuleDescriptor;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.mail.notification.NotificationManager;
import com.atlassian.confluence.mail.notification.listeners.NotificationTemplate;
import com.atlassian.confluence.mail.template.PreRenderedMailNotificationQueueItem;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.AddressablePage;
import com.atlassian.confluence.plugin.descriptor.mail.NotificationContext;
import com.atlassian.confluence.plugin.descriptor.mail.NotificationRenderManager;
import com.atlassian.confluence.plugins.createcontent.api.events.SpaceBlueprintHomePageCreateEvent;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.util.i18n.I18NBean;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.core.task.MultiQueueTaskManager;
import com.atlassian.core.task.Task;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.ModuleCompleteKey;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.web.descriptors.DefaultWebItemModuleDescriptor;
import com.atlassian.user.User;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SpaceHomePageEventListener {
    private static final String EMAIL_RESOURCE_KEY = "com.atlassian.confluence.plugins.confluence-email-resources";
    private static final String TEAM_SPACE_EMAIL_RESOURCES = "team-space-email-resources";
    private static final String TEAM_SPACE_EMAIL_COMPLETE_KEY = "com.atlassian.confluence.plugins.confluence-space-blueprints:team-space-email-resources";
    private static final String TEAM_SPACE_EMAIL_SOY_TEMPLATE = "Confluence.Templates.Team.Space.Notifications.teamSpaceEmail.soy";
    private static final String TEAM_SPACE_ICON_KEY = "team-space-icon";
    private static final String TEAM_SPACE_TYPE = "team-space";
    private final List<DataSource> iconResources = new ArrayList<DataSource>();
    private final UserAccessor userAccessor;
    private final NotificationManager notificationManager;
    private final DataSourceFactory dataSourceFactory;
    private final I18NBeanFactory i18NBeanFactory;
    private final LocaleManager localeManager;
    private final MultiQueueTaskManager taskManager;
    private final NotificationRenderManager notificationRenderManager;
    private final EventPublisher eventPublisher;

    @Autowired
    public SpaceHomePageEventListener(@ComponentImport UserAccessor userAccessor, @ComponentImport NotificationManager notificationManager, @ComponentImport DataSourceFactory dataSourceFactory, @ComponentImport I18NBeanFactory i18NBeanFactory, @ComponentImport LocaleManager localeManager, @ComponentImport MultiQueueTaskManager taskManager, @ComponentImport NotificationRenderManager notificationRenderManager, @ComponentImport EventPublisher eventPublisher) {
        this.userAccessor = userAccessor;
        this.notificationManager = notificationManager;
        this.dataSourceFactory = dataSourceFactory;
        this.i18NBeanFactory = i18NBeanFactory;
        this.localeManager = localeManager;
        this.taskManager = taskManager;
        this.notificationRenderManager = notificationRenderManager;
        this.eventPublisher = eventPublisher;
    }

    @PostConstruct
    public void initialise() {
        this.eventPublisher.register((Object)this);
    }

    @PreDestroy
    public void teardown() {
        this.eventPublisher.unregister((Object)this);
    }

    @EventListener
    public void onSpaceHomePageCreate(SpaceBlueprintHomePageCreateEvent event) {
        if (!"com.atlassian.confluence.plugins.confluence-space-blueprints:team-space-blueprint".equals(event.getSpaceBlueprint().getModuleCompleteKey())) {
            return;
        }
        String members = (String)event.getContext().get("members");
        String description = (String)event.getContext().get("description");
        Space space = event.getSpace();
        String[] userNames = members.split(",");
        ArrayList<ConfluenceUser> users = new ArrayList<ConfluenceUser>();
        for (String username : userNames) {
            ConfluenceUser user = this.userAccessor.getUserByName(username);
            if (user == null) continue;
            this.notificationManager.addSpaceNotification((User)user, space);
            users.add(user);
        }
        ConfluenceUser creator = event.getCreator();
        if (NotificationTemplate.ADG.isEnabled("team.space")) {
            this.sendNotifications(creator, description, space, users);
        }
    }

    void sendNotifications(ConfluenceUser creator, String description, Space space, Iterable<ConfluenceUser> users) {
        ArrayList<ConfluenceUser> allUsers = new ArrayList<ConfluenceUser>();
        HashMap<String, DataSource> avatarsByUsername = new HashMap<String, DataSource>();
        HashMap<ConfluenceUser, String> avatarNamesByUser = new HashMap<ConfluenceUser, String>();
        DataSource avatar = this.dataSourceFactory.getAvatar(creator);
        avatarsByUsername.put(avatar.getName(), avatar);
        avatarNamesByUser.put(creator, avatar.getName());
        for (ConfluenceUser user : users) {
            avatar = this.dataSourceFactory.getAvatar(user);
            avatarsByUsername.put(avatar.getName(), avatar);
            avatarNamesByUser.put(user, avatar.getName());
            allUsers.add(user);
        }
        DataSource senderAvatar = this.dataSourceFactory.getAvatar(creator);
        NotificationContext context = new NotificationContext();
        context.put("spaceName", (Object)space.getName());
        context.put("spaceUrl", (Object)space.getUrlPath());
        context.put("teamSpaceType", (Object)TEAM_SPACE_TYPE);
        context.put("sender", (Object)creator);
        context.put("contentSummary", (Object)description);
        context.put("avatarCid", (Object)senderAvatar.getName());
        context.put("spaceKey", (Object)space.getKey());
        context.put("homePageUrl", (Object)AddressablePage.of((AbstractPage)space.getHomePage()).getUrlPath());
        this.notificationRenderManager.attachActionIconImages("email.adg.space.action.links", context);
        this.populateIcons(context);
        for (ConfluenceUser user : users) {
            if (user.equals((Object)creator)) continue;
            ArrayList teamMembers = new ArrayList(allUsers);
            teamMembers.remove(user);
            context.put("userList", teamMembers);
            context.put("actionLinks", this.getWebItemLinks("email.adg.space.action.links", context, this.localeManager.getLocale((User)user)));
            HashMap teamAvatars = new HashMap(avatarsByUsername);
            teamAvatars.remove(avatarNamesByUser.get(user));
            this.sendTeamSpaceNotification(creator, user, teamAvatars.values(), context);
        }
    }

    private Collection<WebItemView> getWebItemLinks(String section, NotificationContext context, Locale locale) {
        Objects.requireNonNull(locale, "User's locale is not set");
        I18NBean i18n = this.i18NBeanFactory.getI18NBean(locale);
        List webItemModuleDescriptors = this.notificationRenderManager.getDisplayableItems(section, context);
        return webItemModuleDescriptors.stream().map(webItemModuleDescriptor -> {
            DefaultWebItemModuleDescriptor defaultWebItemModuleDescriptor = (DefaultWebItemModuleDescriptor)webItemModuleDescriptor;
            String url = defaultWebItemModuleDescriptor.getLink().getRenderedUrl(context.getMap());
            String i18nKey = webItemModuleDescriptor.getKey();
            String label = i18n.getText(i18nKey);
            return WebItemView.builder().setModuleKey(webItemModuleDescriptor.getKey()).setUrl(url).setUrlWithoutContextPath(url).setLabel(label).build();
        }).collect(Collectors.toList());
    }

    private void sendTeamSpaceNotification(ConfluenceUser creator, ConfluenceUser receivingUser, Iterable<DataSource> teamMemberAvatars, NotificationContext context) {
        I18NBean i18n = this.i18NBeanFactory.getI18NBean(this.localeManager.getLocale((User)receivingUser));
        String subject = i18n.getText("confluence.blueprints.space.team.email.subject", (Object[])new String[]{creator.getFullName()});
        Task notificationTask = this.createNotificationTask(creator, receivingUser, subject, context, teamMemberAvatars);
        this.taskManager.addTask("mail", notificationTask);
    }

    protected Task createNotificationTask(ConfluenceUser creator, ConfluenceUser receiver, String subject, NotificationContext context, Iterable<DataSource> avatarHandlers) {
        PreRenderedMailNotificationQueueItem.Builder builder = PreRenderedMailNotificationQueueItem.with((User)receiver, (String)TEAM_SPACE_EMAIL_SOY_TEMPLATE, (String)subject).andSender((User)creator).andTemplateLocation(TEAM_SPACE_EMAIL_COMPLETE_KEY).andContext(context.getMap()).andRelatedBodyParts(avatarHandlers).andRelatedBodyParts(this.iconResources).andRelatedBodyParts(this.imagesUsedByChromeTemplate());
        return builder.render();
    }

    private void populateIcons(NotificationContext context) {
        ModuleCompleteKey moduleKey = new ModuleCompleteKey("com.atlassian.confluence.plugins.confluence-space-blueprints", TEAM_SPACE_EMAIL_RESOURCES);
        this.dataSourceFactory.getResourceFromModuleByName(moduleKey, TEAM_SPACE_ICON_KEY).ifPresent(this.iconResources::add);
        this.iconResources.addAll(context.getTemplateImageDataSources());
    }

    private Iterable<? extends DataSource> imagesUsedByChromeTemplate() {
        ModuleCompleteKey moduleKey = new ModuleCompleteKey(EMAIL_RESOURCE_KEY, "chrome-template");
        return this.dataSourceFactory.getResourcesFromModules(moduleKey, (Predicate)ResourceModuleDescriptor.Filters.IMAGE);
    }
}

