/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.nutcluster;

import com.atlassian.nutcluster.aws.utility.MetadataUtil;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NutclusterConfigUtils {
    private static final Logger log = LoggerFactory.getLogger(NutclusterConfigUtils.class);
    private static final String IMDS_LOCAL_IP_SUFFIX = "local-ipv4";
    private static final int IMDS_TIMEOUT_IN_SECONDS = 5;
    private static final int IMDS_RETRIES_NO = 10;

    public static String getAwsEc2PrivateIp(@NonNull String defaultIp) {
        try {
            String uri = "http://169.254.169.254/latest/meta-data/local-ipv4";
            return MetadataUtil.retrieveMetadataFromURI((String)uri, (int)5, (int)10);
        }
        catch (Exception e) {
            log.error("Error getting network interface from the AWS metadata url", (Throwable)e);
            return defaultIp;
        }
    }
}

