/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.cache;

import com.atlassian.nutcluster.cache.impl.NutclusterServerCachingProvider;
import com.atlassian.nutcluster.core.NutclusterInstance;
import com.atlassian.nutcluster.logging.ILogger;
import com.atlassian.nutcluster.logging.Logger;
import com.atlassian.nutcluster.nio.ClassLoaderUtil;
import com.atlassian.nutcluster.spi.properties.GroupProperty;
import java.net.URI;
import java.util.Properties;
import javax.cache.CacheException;
import javax.cache.CacheManager;
import javax.cache.configuration.OptionalFeature;
import javax.cache.spi.CachingProvider;

public final class NutclusterCachingProvider
implements CachingProvider {
    public static final String NUTCLUSTER_CONFIG_LOCATION = "hazelcast.config.location";
    public static final String NUTCLUSTER_INSTANCE_NAME = "nutcluster.instance.name";
    public static final String NUTCLUSTER_INSTANCE_ITSELF = "nutcluster.instance.itself";
    private static final String CLIENT_CACHING_PROVIDER_CLASS = "com.atlassian.nutcluster.client.cache.impl.NutclusterClientCachingProvider";
    private static final ILogger LOGGER = Logger.getLogger(NutclusterCachingProvider.class);
    private final CachingProvider delegate;

    public NutclusterCachingProvider() {
        CachingProvider cp = null;
        String providerType = GroupProperty.JCACHE_PROVIDER_TYPE.getSystemProperty();
        if (providerType != null) {
            if ("client".equals(providerType)) {
                cp = this.createClientProvider();
            }
            if ("server".equals(providerType)) {
                cp = new NutclusterServerCachingProvider();
            }
            if (cp == null) {
                throw new CacheException("CacheProvider cannot be created with the provided type: " + providerType);
            }
        } else {
            cp = this.createClientProvider();
            if (cp == null) {
                cp = new NutclusterServerCachingProvider();
            }
        }
        this.delegate = cp;
    }

    private CachingProvider createClientProvider() {
        try {
            return (CachingProvider)ClassLoaderUtil.newInstance(this.getClass().getClassLoader(), CLIENT_CACHING_PROVIDER_CLASS);
        }
        catch (Exception e) {
            LOGGER.finest("Could not load client CachingProvider! Fallback to server one... " + e.toString());
            return null;
        }
    }

    public static Properties propertiesByLocation(String configFileLocation) {
        Properties properties = new Properties();
        properties.setProperty(NUTCLUSTER_CONFIG_LOCATION, configFileLocation);
        return properties;
    }

    public static Properties propertiesByInstanceName(String instanceName) {
        Properties properties = new Properties();
        properties.setProperty(NUTCLUSTER_INSTANCE_NAME, instanceName);
        return properties;
    }

    public static Properties propertiesByInstanceItself(NutclusterInstance instance) {
        Properties properties = new Properties();
        properties.put(NUTCLUSTER_INSTANCE_ITSELF, instance);
        return properties;
    }

    public CacheManager getCacheManager(URI uri, ClassLoader classLoader, Properties properties) {
        return this.delegate.getCacheManager(uri, classLoader, properties);
    }

    public ClassLoader getDefaultClassLoader() {
        return this.delegate.getDefaultClassLoader();
    }

    public URI getDefaultURI() {
        return this.delegate.getDefaultURI();
    }

    public Properties getDefaultProperties() {
        return this.delegate.getDefaultProperties();
    }

    public CacheManager getCacheManager(URI uri, ClassLoader classLoader) {
        return this.delegate.getCacheManager(uri, classLoader);
    }

    public CacheManager getCacheManager() {
        return this.delegate.getCacheManager();
    }

    public void close() {
        this.delegate.close();
    }

    public void close(ClassLoader classLoader) {
        this.delegate.close(classLoader);
    }

    public void close(URI uri, ClassLoader classLoader) {
        this.delegate.close(uri, classLoader);
    }

    public boolean isSupported(OptionalFeature optionalFeature) {
        return this.delegate.isSupported(optionalFeature);
    }

    public String toString() {
        return "NutclusterCachingProvider{delegate=" + String.valueOf(this.delegate) + "}";
    }
}

