/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.cache.impl;

import com.atlassian.nutcluster.cache.CacheEventType;
import com.atlassian.nutcluster.cache.impl.CacheEventContext;
import com.atlassian.nutcluster.cache.impl.CacheEventDataImpl;
import com.atlassian.nutcluster.cache.impl.CacheEventSet;
import com.atlassian.nutcluster.internal.nearcache.impl.invalidation.BatchInvalidator;
import com.atlassian.nutcluster.internal.nearcache.impl.invalidation.InvalidationUtils;
import com.atlassian.nutcluster.internal.nearcache.impl.invalidation.Invalidator;
import com.atlassian.nutcluster.internal.nearcache.impl.invalidation.MetaDataGenerator;
import com.atlassian.nutcluster.internal.nearcache.impl.invalidation.NonStopInvalidator;
import com.atlassian.nutcluster.nio.serialization.Data;
import com.atlassian.nutcluster.spi.EventRegistration;
import com.atlassian.nutcluster.spi.EventService;
import com.atlassian.nutcluster.spi.NodeEngine;
import com.atlassian.nutcluster.spi.properties.GroupProperty;
import com.atlassian.nutcluster.spi.properties.NutclusterProperties;
import java.util.Collection;

public class CacheEventHandler {
    private final NodeEngine nodeEngine;
    private final Invalidator invalidator;

    CacheEventHandler(NodeEngine nodeEngine) {
        this.nodeEngine = nodeEngine;
        this.invalidator = this.createInvalidator();
    }

    private Invalidator createInvalidator() {
        boolean batchingEnabled;
        NutclusterProperties nutclusterProperties = this.nodeEngine.getProperties();
        int batchSize = nutclusterProperties.getInteger(GroupProperty.CACHE_INVALIDATION_MESSAGE_BATCH_SIZE);
        int batchFrequencySeconds = nutclusterProperties.getInteger(GroupProperty.CACHE_INVALIDATION_MESSAGE_BATCH_FREQUENCY_SECONDS);
        boolean bl = batchingEnabled = nutclusterProperties.getBoolean(GroupProperty.CACHE_INVALIDATION_MESSAGE_BATCH_ENABLED) && batchSize > 1;
        if (batchingEnabled) {
            return new BatchInvalidator("hz:impl:cacheService", batchSize, batchFrequencySeconds, InvalidationUtils.TRUE_FILTER, this.nodeEngine);
        }
        return new NonStopInvalidator("hz:impl:cacheService", InvalidationUtils.TRUE_FILTER, this.nodeEngine);
    }

    public MetaDataGenerator getMetaDataGenerator() {
        return this.invalidator.getMetaDataGenerator();
    }

    void publishEvent(CacheEventContext cacheEventContext) {
        String cacheName;
        EventService eventService = this.nodeEngine.getEventService();
        Collection<EventRegistration> candidates = eventService.getRegistrations("hz:impl:cacheService", cacheName = cacheEventContext.getCacheName());
        if (candidates.isEmpty()) {
            return;
        }
        CacheEventType eventType = cacheEventContext.getEventType();
        eventService.publishEvent("hz:impl:cacheService", candidates, (Object)(switch (eventType) {
            case CacheEventType.CREATED, CacheEventType.UPDATED, CacheEventType.REMOVED, CacheEventType.EXPIRED -> {
                CacheEventDataImpl cacheEventData = new CacheEventDataImpl(cacheName, eventType, cacheEventContext.getDataKey(), cacheEventContext.getDataValue(), cacheEventContext.getDataOldValue(), cacheEventContext.isOldValueAvailable());
                CacheEventSet eventSet = new CacheEventSet(eventType, cacheEventContext.getCompletionId());
                eventSet.addEventData(cacheEventData);
                yield eventSet;
            }
            case CacheEventType.EVICTED, CacheEventType.INVALIDATED -> new CacheEventDataImpl(cacheName, eventType, cacheEventContext.getDataKey(), null, null, false);
            case CacheEventType.COMPLETED -> {
                CacheEventDataImpl completedEventData = new CacheEventDataImpl(cacheName, eventType, cacheEventContext.getDataKey(), cacheEventContext.getDataValue(), null, false);
                CacheEventSet eventSet = new CacheEventSet(eventType, cacheEventContext.getCompletionId());
                eventSet.addEventData(completedEventData);
                yield eventSet;
            }
            default -> throw new IllegalArgumentException("Event Type not defined to create an eventData during publish: " + eventType.name());
        }), cacheEventContext.getOrderKey());
    }

    void publishEvent(String cacheNameWithPrefix, CacheEventSet eventSet, int orderKey) {
        EventService eventService = this.nodeEngine.getEventService();
        Collection<EventRegistration> candidates = eventService.getRegistrations("hz:impl:cacheService", cacheNameWithPrefix);
        if (candidates.isEmpty()) {
            return;
        }
        eventService.publishEvent("hz:impl:cacheService", candidates, (Object)eventSet, orderKey);
    }

    void sendInvalidationEvent(String name, Data key, String sourceUuid) {
        if (key == null) {
            this.invalidator.invalidateAllKeys(name, sourceUuid);
        } else {
            this.invalidator.invalidateKey(key, name, sourceUuid);
        }
    }

    public void resetPartitionMetaData(String name, int partitionId) {
        this.invalidator.resetPartitionMetaData(name, partitionId);
    }

    public void destroy(String name, String sourceUuid) {
        this.invalidator.destroy(name, sourceUuid);
    }

    void shutdown() {
        this.invalidator.shutdown();
    }
}

