/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.cache.impl;

import com.atlassian.nutcluster.cache.NutclusterCacheManager;
import com.atlassian.nutcluster.cache.impl.AbstractNutclusterCacheManager;
import com.atlassian.nutcluster.cache.impl.CacheProxy;
import com.atlassian.nutcluster.cache.impl.CacheService;
import com.atlassian.nutcluster.cache.impl.ICacheInternal;
import com.atlassian.nutcluster.cache.impl.ICacheService;
import com.atlassian.nutcluster.cache.impl.NutclusterServerCachingProvider;
import com.atlassian.nutcluster.cache.impl.PreJoinCacheConfig;
import com.atlassian.nutcluster.cache.impl.merge.policy.CacheMergePolicyProvider;
import com.atlassian.nutcluster.cache.impl.operation.CacheGetConfigOperation;
import com.atlassian.nutcluster.cache.impl.operation.CacheManagementConfigOperation;
import com.atlassian.nutcluster.config.CacheConfig;
import com.atlassian.nutcluster.core.Member;
import com.atlassian.nutcluster.core.NutclusterInstance;
import com.atlassian.nutcluster.instance.NutclusterInstanceCacheManager;
import com.atlassian.nutcluster.instance.NutclusterInstanceImpl;
import com.atlassian.nutcluster.instance.NutclusterInstanceProxy;
import com.atlassian.nutcluster.internal.config.ConfigValidator;
import com.atlassian.nutcluster.internal.config.MergePolicyValidator;
import com.atlassian.nutcluster.spi.InternalCompletableFuture;
import com.atlassian.nutcluster.spi.NodeEngine;
import com.atlassian.nutcluster.spi.OperationService;
import com.atlassian.nutcluster.util.FutureUtil;
import com.atlassian.nutcluster.util.Preconditions;
import java.net.URI;
import java.util.ArrayList;
import java.util.Properties;
import java.util.concurrent.TimeUnit;

public class NutclusterServerCacheManager
extends AbstractNutclusterCacheManager {
    private final NutclusterInstanceImpl instance;
    private final NodeEngine nodeEngine;
    private final CacheService cacheService;

    public NutclusterServerCacheManager(NutclusterServerCachingProvider cachingProvider, NutclusterInstance NutclusterInstance2, URI uri, ClassLoader classLoader, Properties properties) {
        super(cachingProvider, NutclusterInstance2, uri, classLoader, properties);
        this.instance = NutclusterInstance2 instanceof NutclusterInstanceProxy ? ((NutclusterInstanceProxy)NutclusterInstance2).getOriginal() : (NutclusterInstanceImpl)NutclusterInstance2;
        this.nodeEngine = this.instance.node.getNodeEngine();
        this.cacheService = (CacheService)this.nodeEngine.getService("hz:impl:cacheService");
    }

    public void enableManagement(String cacheName, boolean enabled) {
        this.ensureOpen();
        Preconditions.checkNotNull(cacheName, "cacheName cannot be null");
        String cacheNameWithPrefix = this.getCacheNameWithPrefix(cacheName);
        this.cacheService.setManagementEnabled(null, cacheNameWithPrefix, enabled);
        this.enableStatisticManagementOnOtherNodes(cacheName, false, enabled);
    }

    public void enableStatistics(String cacheName, boolean enabled) {
        this.ensureOpen();
        Preconditions.checkNotNull(cacheName, "cacheName cannot be null");
        String cacheNameWithPrefix = this.getCacheNameWithPrefix(cacheName);
        this.cacheService.setStatisticsEnabled(null, cacheNameWithPrefix, enabled);
        this.enableStatisticManagementOnOtherNodes(cacheName, true, enabled);
    }

    private void enableStatisticManagementOnOtherNodes(String cacheName, boolean statOrMan, boolean enabled) {
        String cacheNameWithPrefix = this.getCacheNameWithPrefix(cacheName);
        OperationService operationService = this.nodeEngine.getOperationService();
        ArrayList futures = new ArrayList();
        for (Member member : this.nodeEngine.getClusterService().getMembers()) {
            if (member.localMember()) continue;
            CacheManagementConfigOperation op = new CacheManagementConfigOperation(cacheNameWithPrefix, statOrMan, enabled);
            InternalCompletableFuture future = operationService.invokeOnTarget("hz:impl:cacheService", op, member.getAddress());
            futures.add(future);
        }
        FutureUtil.waitWithDeadline(futures, 60L, TimeUnit.SECONDS);
    }

    @Override
    protected <K, V> void addCacheConfigIfAbsent(CacheConfig<K, V> cacheConfig) {
        this.cacheService.putCacheConfigIfAbsent(cacheConfig);
    }

    @Override
    protected <K, V> CacheConfig<K, V> findCacheConfig(String cacheName, String simpleCacheName) {
        CacheConfig config = this.cacheService.getCacheConfig(cacheName);
        if (config == null) {
            config = this.cacheService.findCacheConfig(simpleCacheName);
            if (config != null) {
                config.setManagerPrefix(cacheName.substring(0, cacheName.lastIndexOf(simpleCacheName)));
            } else {
                config = this.getCacheConfig(cacheName, simpleCacheName);
            }
        }
        if (config != null) {
            this.createCacheConfig(cacheName, config);
        }
        return config;
    }

    @Override
    protected <K, V> void createCacheConfig(String cacheName, CacheConfig<K, V> config) {
        this.cacheService.createCacheConfigOnAllMembers(PreJoinCacheConfig.of(config));
    }

    @Override
    protected <K, V> ICacheInternal<K, V> createCacheProxy(CacheConfig<K, V> cacheConfig) {
        NutclusterInstanceCacheManager cacheManager = this.instance.getCacheManager();
        CacheProxy cacheProxy = (CacheProxy)cacheManager.getCacheByFullName(cacheConfig.getNameWithPrefix());
        cacheProxy.setCacheManager(this);
        return cacheProxy;
    }

    @Override
    protected <K, V> CacheConfig<K, V> getCacheConfig(String cacheNameWithPrefix, String cacheName) {
        CacheGetConfigOperation op = new CacheGetConfigOperation(cacheNameWithPrefix, cacheName);
        int partitionId = this.nodeEngine.getPartitionService().getPartitionId(cacheNameWithPrefix);
        InternalCompletableFuture f = this.nodeEngine.getOperationService().invokeOnPartition("hz:impl:cacheService", op, partitionId);
        return (CacheConfig)f.join();
    }

    @Override
    protected void removeCacheConfigFromLocal(String cacheNameWithPrefix) {
        this.cacheService.deleteCacheConfig(cacheNameWithPrefix);
        super.removeCacheConfigFromLocal(cacheNameWithPrefix);
    }

    @Override
    protected <K, V> void validateCacheConfig(CacheConfig<K, V> cacheConfig) {
        CacheMergePolicyProvider mergePolicyProvider = this.cacheService.getMergePolicyProvider();
        ConfigValidator.checkCacheConfig(cacheConfig, mergePolicyProvider);
        Object mergePolicy = mergePolicyProvider.getMergePolicy(cacheConfig.getMergePolicy());
        MergePolicyValidator.checkMergePolicySupportsInMemoryFormat(cacheConfig.getName(), mergePolicy, cacheConfig.getInMemoryFormat(), true, this.nodeEngine.getLogger(NutclusterCacheManager.class));
    }

    public <T> T unwrap(Class<T> clazz) {
        if (NutclusterServerCacheManager.class.isAssignableFrom(clazz)) {
            return (T)this;
        }
        throw new IllegalArgumentException();
    }

    @Override
    protected void postClose() {
        if (this.properties.getProperty("hazelcast.config.location") != null) {
            this.NutclusterInstance.shutdown();
        }
    }

    @Override
    protected void onShuttingDown() {
        this.close();
    }

    public ICacheService getCacheService() {
        return this.cacheService;
    }
}

