/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.cache.impl;

import com.atlassian.nutcluster.cache.impl.AbstractNutclusterCacheManager;
import com.atlassian.nutcluster.cache.impl.AbstractNutclusterCachingProvider;
import com.atlassian.nutcluster.cache.impl.NutclusterServerCacheManager;
import com.atlassian.nutcluster.config.Config;
import com.atlassian.nutcluster.config.XmlConfigBuilder;
import com.atlassian.nutcluster.core.Nutcluster;
import com.atlassian.nutcluster.core.NutclusterInstance;
import com.atlassian.nutcluster.instance.NutclusterInstanceFactory;
import com.atlassian.nutcluster.util.ExceptionUtil;
import com.atlassian.nutcluster.util.StringUtil;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Properties;

public final class NutclusterServerCachingProvider
extends AbstractNutclusterCachingProvider {
    public static NutclusterServerCachingProvider createCachingProvider(NutclusterInstance NutclusterInstance2) {
        NutclusterServerCachingProvider cachingProvider = new NutclusterServerCachingProvider();
        cachingProvider.NutclusterInstance = NutclusterInstance2;
        return cachingProvider;
    }

    @Override
    protected <T extends AbstractNutclusterCacheManager> T createCacheManager(NutclusterInstance instance, URI uri, ClassLoader classLoader, Properties properties) {
        return (T)new NutclusterServerCacheManager(this, instance, uri, classLoader, properties);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected NutclusterInstance getOrCreateInstance(URI uri, ClassLoader classLoader, Properties properties) throws URISyntaxException, IOException {
        boolean isDefaultURI;
        NutclusterInstance instanceItself = (NutclusterInstance)properties.get("nutcluster.instance.itself");
        if (instanceItself != null) {
            return instanceItself;
        }
        String location = properties.getProperty("hazelcast.config.location");
        String instanceName = properties.getProperty("nutcluster.instance.name");
        if (location != null) {
            Config config = this.getConfigFromLocation(location, classLoader, instanceName);
            return NutclusterInstanceFactory.getOrCreateNutclusterInstance(config);
        }
        if (instanceName != null) {
            return this.getOrCreateByInstanceName(instanceName);
        }
        boolean bl = isDefaultURI = uri == null || uri.equals(this.getDefaultURI());
        if (isDefaultURI) return this.getDefaultInstance();
        if (this.isConfigLocation(uri)) {
            try {
                Config config = this.getConfigFromLocation(uri, classLoader, null);
                return NutclusterInstanceFactory.getOrCreateNutclusterInstance(config);
            }
            catch (Exception e) {
                if (!LOGGER.isFinestEnabled()) return null;
                LOGGER.finest("Could not get or create Nutcluster instance from URI " + uri.toString(), e);
                return null;
            }
        } else {
            try {
                return this.getOrCreateByInstanceName(uri.toString());
            }
            catch (Exception e) {
                if (!LOGGER.isFinestEnabled()) return null;
                LOGGER.finest("Could not get Nutcluster instance from instance name " + uri.toString(), e);
            }
        }
        return null;
    }

    private NutclusterInstance getDefaultInstance() {
        if (this.NutclusterInstance == null) {
            Config config = this.getDefaultConfig();
            this.NutclusterInstance = StringUtil.isNullOrEmptyAfterTrim(config.getInstanceName()) ? Nutcluster.newNutclusterInstance() : Nutcluster.getOrCreateNutclusterInstance(config);
        }
        return this.NutclusterInstance;
    }

    private NutclusterInstance getOrCreateByInstanceName(String instanceName) {
        NutclusterInstance instance = Nutcluster.getNutclusterInstanceByName(instanceName);
        if (instance == null) {
            Config config = this.getDefaultConfig();
            config.setInstanceName(instanceName);
            instance = Nutcluster.getOrCreateNutclusterInstance(config);
        }
        return instance;
    }

    private Config getDefaultConfig() {
        Config config = new XmlConfigBuilder().build();
        if (this.namedDefaultHzInstance && StringUtil.isNullOrEmpty(config.getInstanceName())) {
            config.setInstanceName("_ncInstance_jcache_shared");
        }
        return config;
    }

    private Config getConfigFromLocation(String location, ClassLoader classLoader, String instanceName) throws URISyntaxException, IOException {
        URI uri = new URI(location);
        return this.getConfigFromLocation(uri, classLoader, instanceName);
    }

    private Config getConfigFromLocation(URI location, ClassLoader classLoader, String instanceName) throws URISyntaxException, IOException {
        URL configURL;
        ClassLoader theClassLoader;
        String scheme = location.getScheme();
        if (scheme == null) {
            location = new URI(System.getProperty(location.getRawSchemeSpecificPart()));
            scheme = location.getScheme();
        }
        ClassLoader classLoader2 = theClassLoader = classLoader == null ? this.getDefaultClassLoader() : classLoader;
        if ("classpath".equals(scheme)) {
            configURL = theClassLoader.getResource(location.getRawSchemeSpecificPart());
        } else if ("file".equals(scheme) || "http".equals(scheme) || "https".equals(scheme)) {
            configURL = location.toURL();
        } else {
            throw new URISyntaxException(location.toString(), "Unsupported protocol in configuration location URL");
        }
        try {
            return this.getConfig(configURL, theClassLoader, instanceName);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    private Config getConfig(URL configURL, ClassLoader theClassLoader, String instanceName) throws IOException {
        Config config = new XmlConfigBuilder(configURL).build().setClassLoader(theClassLoader);
        if (instanceName != null) {
            config.setInstanceName(instanceName);
        } else if (config.getInstanceName() == null) {
            config.setInstanceName(configURL.toString());
        }
        return config;
    }

    public String toString() {
        return "NutclusterServerCachingProvider{NutclusterInstance=" + String.valueOf(this.NutclusterInstance) + "}";
    }
}

