/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.cache.impl.journal;

import com.atlassian.nutcluster.cache.impl.CacheDataSerializerHook;
import com.atlassian.nutcluster.cache.impl.CacheService;
import com.atlassian.nutcluster.cache.impl.journal.CacheEventJournal;
import com.atlassian.nutcluster.internal.journal.EventJournalInitialSubscriberState;
import com.atlassian.nutcluster.nio.serialization.IdentifiedDataSerializable;
import com.atlassian.nutcluster.spi.ObjectNamespace;
import com.atlassian.nutcluster.spi.PartitionAwareOperation;
import com.atlassian.nutcluster.spi.ReadonlyOperation;
import com.atlassian.nutcluster.spi.impl.AbstractNamedOperation;

public class CacheEventJournalSubscribeOperation
extends AbstractNamedOperation
implements PartitionAwareOperation,
IdentifiedDataSerializable,
ReadonlyOperation {
    private EventJournalInitialSubscriberState response;
    private ObjectNamespace namespace;

    public CacheEventJournalSubscribeOperation() {
    }

    public CacheEventJournalSubscribeOperation(String name) {
        super(name);
    }

    @Override
    public void beforeRun() throws Exception {
        super.beforeRun();
        this.namespace = CacheService.getObjectNamespace(this.name);
        CacheService service = (CacheService)this.getService();
        if (!service.getEventJournal().hasEventJournal(this.namespace)) {
            throw new UnsupportedOperationException("Cannot subscribe to event journal because it is either not configured or disabled for cache " + this.name);
        }
    }

    @Override
    public void run() {
        CacheService service = (CacheService)this.getService();
        CacheEventJournal eventJournal = service.getEventJournal();
        long newestSequence = eventJournal.newestSequence(this.namespace, this.getPartitionId());
        long oldestSequence = eventJournal.oldestSequence(this.namespace, this.getPartitionId());
        this.response = new EventJournalInitialSubscriberState(oldestSequence, newestSequence);
    }

    @Override
    public int getFactoryId() {
        return CacheDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 56;
    }

    @Override
    public String getServiceName() {
        return "hz:impl:cacheService";
    }

    @Override
    public EventJournalInitialSubscriberState getResponse() {
        return this.response;
    }
}

