/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.cache.impl.journal;

import com.atlassian.nutcluster.cache.impl.CacheDataSerializerHook;
import com.atlassian.nutcluster.nio.ObjectDataInput;
import com.atlassian.nutcluster.nio.ObjectDataOutput;
import com.atlassian.nutcluster.nio.serialization.Data;
import com.atlassian.nutcluster.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;

public class InternalEventJournalCacheEvent
implements IdentifiedDataSerializable {
    protected Data dataKey;
    protected Data dataNewValue;
    protected Data dataOldValue;
    protected int eventType;

    public InternalEventJournalCacheEvent() {
    }

    public InternalEventJournalCacheEvent(Data dataKey, Data dataNewValue, Data dataOldValue, int eventType) {
        this.eventType = eventType;
        this.dataKey = dataKey;
        this.dataNewValue = dataNewValue;
        this.dataOldValue = dataOldValue;
    }

    public Data getDataKey() {
        return this.dataKey;
    }

    public Data getDataNewValue() {
        return this.dataNewValue;
    }

    public Data getDataOldValue() {
        return this.dataOldValue;
    }

    public int getEventType() {
        return this.eventType;
    }

    @Override
    public int getFactoryId() {
        return CacheDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 59;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeInt(this.eventType);
        out.writeData(this.dataKey);
        out.writeData(this.dataNewValue);
        out.writeData(this.dataOldValue);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.eventType = in.readInt();
        this.dataKey = in.readData();
        this.dataNewValue = in.readData();
        this.dataOldValue = in.readData();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InternalEventJournalCacheEvent that = (InternalEventJournalCacheEvent)o;
        if (this.eventType != that.eventType) {
            return false;
        }
        if (this.dataKey != null ? !this.dataKey.equals(that.dataKey) : that.dataKey != null) {
            return false;
        }
        if (this.dataNewValue != null ? !this.dataNewValue.equals(that.dataNewValue) : that.dataNewValue != null) {
            return false;
        }
        return this.dataOldValue != null ? this.dataOldValue.equals(that.dataOldValue) : that.dataOldValue == null;
    }

    public int hashCode() {
        int result = this.dataKey != null ? this.dataKey.hashCode() : 0;
        result = 31 * result + (this.dataNewValue != null ? this.dataNewValue.hashCode() : 0);
        result = 31 * result + (this.dataOldValue != null ? this.dataOldValue.hashCode() : 0);
        result = 31 * result + this.eventType;
        return result;
    }

    public String toString() {
        return "InternalEventJournalCacheEvent{eventType=" + this.eventType + "}";
    }
}

