/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.cache.impl.operation;

import com.atlassian.nutcluster.cache.impl.CacheDataSerializerHook;
import com.atlassian.nutcluster.cache.impl.operation.CacheRemoveAllOperation;
import com.atlassian.nutcluster.nio.ObjectDataInput;
import com.atlassian.nutcluster.nio.ObjectDataOutput;
import com.atlassian.nutcluster.nio.serialization.Data;
import com.atlassian.nutcluster.nio.serialization.IdentifiedDataSerializable;
import com.atlassian.nutcluster.spi.Operation;
import com.atlassian.nutcluster.spi.OperationFactory;
import com.atlassian.nutcluster.util.SetUtil;
import java.io.IOException;
import java.util.Set;

public class CacheRemoveAllOperationFactory
implements OperationFactory,
IdentifiedDataSerializable {
    private String name;
    private Set<Data> keys;
    private int completionId;

    public CacheRemoveAllOperationFactory() {
    }

    public CacheRemoveAllOperationFactory(String name, Set<Data> keys, int completionId) {
        this.name = name;
        this.keys = keys;
        this.completionId = completionId;
    }

    @Override
    public Operation createOperation() {
        return new CacheRemoveAllOperation(this.name, this.keys, this.completionId);
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeInt(this.completionId);
        out.writeInt(this.keys == null ? -1 : this.keys.size());
        if (this.keys != null) {
            for (Data key : this.keys) {
                out.writeData(key);
            }
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.name = in.readUTF();
        this.completionId = in.readInt();
        int size = in.readInt();
        if (size == -1) {
            return;
        }
        this.keys = SetUtil.createHashSet(size);
        for (int i = 0; i < size; ++i) {
            this.keys.add(in.readData());
        }
    }

    @Override
    public int getFactoryId() {
        return CacheDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 36;
    }
}

