/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.client.impl;

import com.atlassian.nutcluster.client.impl.ClientEndpoint;
import com.atlassian.nutcluster.client.impl.ClientEndpointManager;
import com.atlassian.nutcluster.core.ClientType;
import com.atlassian.nutcluster.instance.BuildInfo;
import com.atlassian.nutcluster.logging.ILogger;
import com.atlassian.nutcluster.nio.Connection;
import com.atlassian.nutcluster.spi.ExecutionService;
import com.atlassian.nutcluster.spi.properties.GroupProperty;
import com.atlassian.nutcluster.spi.properties.NutclusterProperties;
import com.atlassian.nutcluster.util.Clock;
import com.atlassian.nutcluster.util.StringUtil;
import java.util.concurrent.TimeUnit;

public class ClientHeartbeatMonitor
implements Runnable {
    private static final int HEART_BEAT_CHECK_INTERVAL_SECONDS = 10;
    private static final int DEFAULT_CLIENT_HEARTBEAT_TIMEOUT_SECONDS = 60;
    private final ClientEndpointManager clientEndpointManager;
    private final long heartbeatTimeoutSeconds;
    private final ExecutionService executionService;
    private final ILogger logger;

    public ClientHeartbeatMonitor(ClientEndpointManager clientEndpointManager, ILogger logger, ExecutionService executionService, NutclusterProperties nutclusterProperties) {
        this.clientEndpointManager = clientEndpointManager;
        this.logger = logger;
        this.executionService = executionService;
        this.heartbeatTimeoutSeconds = this.getHeartbeatTimeout(nutclusterProperties);
    }

    private long getHeartbeatTimeout(NutclusterProperties nutclusterProperties) {
        long configuredTimeout = nutclusterProperties.getSeconds(GroupProperty.CLIENT_HEARTBEAT_TIMEOUT_SECONDS);
        if (configuredTimeout > 0L) {
            return configuredTimeout;
        }
        return 60L;
    }

    public void start() {
        this.executionService.scheduleWithRepetition(this, 10L, 10L, TimeUnit.SECONDS);
    }

    @Override
    public void run() {
        this.cleanupEndpointsWithDeadConnections();
        for (ClientEndpoint clientEndpoint : this.clientEndpointManager.getEndpoints()) {
            this.monitor(clientEndpoint);
        }
    }

    private void cleanupEndpointsWithDeadConnections() {
        for (ClientEndpoint endpoint : this.clientEndpointManager.getEndpoints()) {
            if (endpoint.getConnection().isAlive()) continue;
            if (this.logger.isFineEnabled()) {
                this.logger.fine("Cleaning up endpoints with dead connection " + String.valueOf(endpoint));
            }
            this.clientEndpointManager.removeEndpoint(endpoint);
        }
    }

    private void monitor(ClientEndpoint clientEndpoint) {
        long currentTimeMillis;
        long timeoutInMillis;
        if (clientEndpoint.isOwnerConnection() && ClientType.CPP.equals((Object)clientEndpoint.getClientType()) && clientEndpoint.getClientVersion() < BuildInfo.calculateVersion("3.10")) {
            return;
        }
        Connection connection = clientEndpoint.getConnection();
        long lastTimePacketReceived = connection.lastReadTimeMillis();
        if (lastTimePacketReceived + (timeoutInMillis = TimeUnit.SECONDS.toMillis(this.heartbeatTimeoutSeconds)) < (currentTimeMillis = Clock.currentTimeMillis())) {
            String message = "Client heartbeat is timed out, closing connection to " + String.valueOf(connection) + ". Now: " + StringUtil.timeToString(currentTimeMillis) + ". LastTimePacketReceived: " + StringUtil.timeToString(lastTimePacketReceived);
            connection.close(message, null);
        }
    }
}

