/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.client.impl;

import com.atlassian.nutcluster.client.impl.ClientEngine;
import com.atlassian.nutcluster.core.Client;
import com.atlassian.nutcluster.core.ClientListener;
import com.atlassian.nutcluster.core.ClientService;
import com.atlassian.nutcluster.instance.Node;
import com.atlassian.nutcluster.spi.EventRegistration;
import com.atlassian.nutcluster.spi.EventService;
import com.atlassian.nutcluster.spi.NodeEngine;
import com.atlassian.nutcluster.util.Preconditions;
import java.util.Collection;

public final class ClientServiceProxy
implements ClientService {
    private final ClientEngine clientEngine;
    private final NodeEngine nodeEngine;

    public ClientServiceProxy(Node node) {
        this.clientEngine = node.clientEngine;
        this.nodeEngine = node.nodeEngine;
    }

    @Override
    public Collection<Client> getConnectedClients() {
        return this.clientEngine.getClients();
    }

    @Override
    public String addClientListener(ClientListener clientListener) {
        Preconditions.checkNotNull(clientListener, "clientListener should not be null");
        EventService eventService = this.nodeEngine.getEventService();
        EventRegistration registration = eventService.registerLocalListener("hz:core:clientEngine", "hz:core:clientEngine", clientListener);
        return registration.getId();
    }

    @Override
    public boolean removeClientListener(String registrationId) {
        Preconditions.checkNotNull(registrationId, "registrationId should not be null");
        EventService eventService = this.nodeEngine.getEventService();
        return eventService.deregisterListener("hz:core:clientEngine", "hz:core:clientEngine", registrationId);
    }
}

