/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.client.impl.protocol.codec;

import com.atlassian.nutcluster.client.impl.protocol.ClientMessage;
import com.atlassian.nutcluster.client.impl.protocol.codec.CacheMessageType;
import com.atlassian.nutcluster.client.impl.protocol.util.ParameterUtil;
import com.atlassian.nutcluster.nio.serialization.Data;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;

@SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
public final class CacheReplaceCodec {
    public static final CacheMessageType REQUEST_TYPE = CacheMessageType.CACHE_REPLACE;
    public static final int RESPONSE_TYPE = 105;

    public static ClientMessage encodeRequest(String name, Data key, Data oldValue, Data newValue, Data expiryPolicy, int completionId) {
        int requiredDataSize = RequestParameters.calculateDataSize(name, key, oldValue, newValue, expiryPolicy, completionId);
        ClientMessage clientMessage = ClientMessage.createForEncode(requiredDataSize);
        clientMessage.setMessageType(REQUEST_TYPE.id());
        clientMessage.setRetryable(false);
        clientMessage.setAcquiresResource(false);
        clientMessage.setOperationName("Cache.replace");
        clientMessage.set(name);
        clientMessage.set(key);
        if (oldValue == null) {
            boolean oldValue_isNull = true;
            clientMessage.set(oldValue_isNull);
        } else {
            boolean oldValue_isNull = false;
            clientMessage.set(oldValue_isNull);
            clientMessage.set(oldValue);
        }
        clientMessage.set(newValue);
        if (expiryPolicy == null) {
            boolean expiryPolicy_isNull = true;
            clientMessage.set(expiryPolicy_isNull);
        } else {
            boolean expiryPolicy_isNull = false;
            clientMessage.set(expiryPolicy_isNull);
            clientMessage.set(expiryPolicy);
        }
        clientMessage.set(completionId);
        clientMessage.updateFrameLength();
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        RequestParameters parameters = new RequestParameters();
        String name = null;
        parameters.name = name = clientMessage.getStringUtf8();
        Data key = null;
        parameters.key = key = clientMessage.getData();
        Data oldValue = null;
        boolean oldValue_isNull = clientMessage.getBoolean();
        if (!oldValue_isNull) {
            parameters.oldValue = oldValue = clientMessage.getData();
        }
        Data newValue = null;
        parameters.newValue = newValue = clientMessage.getData();
        Data expiryPolicy = null;
        boolean expiryPolicy_isNull = clientMessage.getBoolean();
        if (!expiryPolicy_isNull) {
            parameters.expiryPolicy = expiryPolicy = clientMessage.getData();
        }
        int completionId = 0;
        parameters.completionId = completionId = clientMessage.getInt();
        return parameters;
    }

    public static ClientMessage encodeResponse(Data response) {
        int requiredDataSize = ResponseParameters.calculateDataSize(response);
        ClientMessage clientMessage = ClientMessage.createForEncode(requiredDataSize);
        clientMessage.setMessageType(105);
        if (response == null) {
            boolean response_isNull = true;
            clientMessage.set(response_isNull);
        } else {
            boolean response_isNull = false;
            clientMessage.set(response_isNull);
            clientMessage.set(response);
        }
        clientMessage.updateFrameLength();
        return clientMessage;
    }

    public static ResponseParameters decodeResponse(ClientMessage clientMessage) {
        ResponseParameters parameters = new ResponseParameters();
        Data response = null;
        boolean response_isNull = clientMessage.getBoolean();
        if (!response_isNull) {
            parameters.response = response = clientMessage.getData();
        }
        return parameters;
    }

    public static class RequestParameters {
        public static final CacheMessageType TYPE = REQUEST_TYPE;
        public String name;
        public Data key;
        public Data oldValue;
        public Data newValue;
        public Data expiryPolicy;
        public int completionId;

        public static int calculateDataSize(String name, Data key, Data oldValue, Data newValue, Data expiryPolicy, int completionId) {
            int dataSize = ClientMessage.HEADER_SIZE;
            dataSize += ParameterUtil.calculateDataSize(name);
            dataSize += ParameterUtil.calculateDataSize(key);
            ++dataSize;
            if (oldValue != null) {
                dataSize += ParameterUtil.calculateDataSize(oldValue);
            }
            dataSize += ParameterUtil.calculateDataSize(newValue);
            ++dataSize;
            if (expiryPolicy != null) {
                dataSize += ParameterUtil.calculateDataSize(expiryPolicy);
            }
            return dataSize += 4;
        }
    }

    public static class ResponseParameters {
        public Data response;

        public static int calculateDataSize(Data response) {
            int dataSize = ClientMessage.HEADER_SIZE;
            ++dataSize;
            if (response != null) {
                dataSize += ParameterUtil.calculateDataSize(response);
            }
            return dataSize;
        }
    }
}

