/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.client.impl.protocol.codec;

import com.atlassian.nutcluster.client.impl.protocol.ClientMessage;
import com.atlassian.nutcluster.client.impl.protocol.codec.TransactionalMapMessageType;
import com.atlassian.nutcluster.client.impl.protocol.util.ParameterUtil;
import com.atlassian.nutcluster.nio.serialization.Data;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
public final class TransactionalMapKeySetCodec {
    public static final TransactionalMapMessageType REQUEST_TYPE = TransactionalMapMessageType.TRANSACTIONALMAP_KEYSET;
    public static final int RESPONSE_TYPE = 106;

    public static ClientMessage encodeRequest(String name, String txnId, long threadId) {
        int requiredDataSize = RequestParameters.calculateDataSize(name, txnId, threadId);
        ClientMessage clientMessage = ClientMessage.createForEncode(requiredDataSize);
        clientMessage.setMessageType(REQUEST_TYPE.id());
        clientMessage.setRetryable(false);
        clientMessage.setAcquiresResource(false);
        clientMessage.setOperationName("TransactionalMap.keySet");
        clientMessage.set(name);
        clientMessage.set(txnId);
        clientMessage.set(threadId);
        clientMessage.updateFrameLength();
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        RequestParameters parameters = new RequestParameters();
        String name = null;
        parameters.name = name = clientMessage.getStringUtf8();
        String txnId = null;
        parameters.txnId = txnId = clientMessage.getStringUtf8();
        long threadId = 0L;
        parameters.threadId = threadId = clientMessage.getLong();
        return parameters;
    }

    public static ClientMessage encodeResponse(Collection<Data> response) {
        int requiredDataSize = ResponseParameters.calculateDataSize(response);
        ClientMessage clientMessage = ClientMessage.createForEncode(requiredDataSize);
        clientMessage.setMessageType(106);
        clientMessage.set(response.size());
        for (Data response_item : response) {
            clientMessage.set(response_item);
        }
        clientMessage.updateFrameLength();
        return clientMessage;
    }

    public static ResponseParameters decodeResponse(ClientMessage clientMessage) {
        ResponseParameters parameters = new ResponseParameters();
        ArrayList<Data> response = null;
        int response_size = clientMessage.getInt();
        response = new ArrayList<Data>(response_size);
        for (int response_index = 0; response_index < response_size; ++response_index) {
            Data response_item = clientMessage.getData();
            response.add(response_item);
        }
        parameters.response = response;
        return parameters;
    }

    public static class RequestParameters {
        public static final TransactionalMapMessageType TYPE = REQUEST_TYPE;
        public String name;
        public String txnId;
        public long threadId;

        public static int calculateDataSize(String name, String txnId, long threadId) {
            int dataSize = ClientMessage.HEADER_SIZE;
            dataSize += ParameterUtil.calculateDataSize(name);
            dataSize += ParameterUtil.calculateDataSize(txnId);
            return dataSize += 8;
        }
    }

    public static class ResponseParameters {
        public List<Data> response;

        public static int calculateDataSize(Collection<Data> response) {
            int dataSize = ClientMessage.HEADER_SIZE;
            dataSize += 4;
            for (Data response_item : response) {
                dataSize += ParameterUtil.calculateDataSize(response_item);
            }
            return dataSize;
        }
    }
}

