/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.client.impl.protocol.task;

import com.atlassian.nutcluster.client.impl.protocol.ClientMessage;
import com.atlassian.nutcluster.client.impl.protocol.task.AbstractMessageTask;
import com.atlassian.nutcluster.core.ExecutionCallback;
import com.atlassian.nutcluster.instance.Node;
import com.atlassian.nutcluster.nio.Connection;
import com.atlassian.nutcluster.spi.InternalCompletableFuture;
import com.atlassian.nutcluster.spi.Operation;
import com.atlassian.nutcluster.spi.impl.executionservice.InternalExecutionService;
import com.atlassian.nutcluster.spi.impl.operationexecutor.impl.PartitionOperationThread;
import com.atlassian.nutcluster.util.executor.ManagedExecutorService;
import java.util.concurrent.Executor;

public abstract class AbstractPartitionMessageTask<P>
extends AbstractMessageTask<P>
implements ExecutionCallback,
Executor {
    protected AbstractPartitionMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    protected void beforeProcess() {
    }

    protected void beforeResponse() {
    }

    protected void afterResponse() {
    }

    @Override
    public final void processMessage() {
        this.beforeProcess();
        Operation op = this.prepareOperation();
        op.setCallerUuid(this.endpoint.getUuid());
        InternalCompletableFuture f = this.nodeEngine.getOperationService().createInvocationBuilder(this.getServiceName(), op, this.getPartitionId()).setResultDeserialized(false).invoke();
        f.andThen(this, this);
    }

    protected abstract Operation prepareOperation();

    @Override
    public void execute(Runnable command) {
        if (Thread.currentThread().getClass() == PartitionOperationThread.class) {
            command.run();
        } else {
            InternalExecutionService executionService = this.nodeEngine.getExecutionService();
            ManagedExecutorService executor = executionService.getExecutor("hz:async");
            executor.execute(command);
        }
    }

    public void onResponse(Object response) {
        this.beforeResponse();
        this.sendResponse(response);
        this.afterResponse();
    }

    @Override
    public void onFailure(Throwable t) {
        this.beforeResponse();
        this.handleProcessingFailure(t);
        this.afterResponse();
    }
}

