/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.client.impl.protocol.task;

import com.atlassian.nutcluster.client.impl.client.ClientPrincipal;
import com.atlassian.nutcluster.client.impl.protocol.ClientMessage;
import com.atlassian.nutcluster.client.impl.protocol.codec.ClientAuthenticationCustomCodec;
import com.atlassian.nutcluster.client.impl.protocol.task.AuthenticationBaseMessageTask;
import com.atlassian.nutcluster.core.Member;
import com.atlassian.nutcluster.instance.Node;
import com.atlassian.nutcluster.nio.Address;
import com.atlassian.nutcluster.nio.Connection;
import com.atlassian.nutcluster.security.Credentials;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class AuthenticationCustomCredentialsMessageTask
extends AuthenticationBaseMessageTask<ClientAuthenticationCustomCodec.RequestParameters> {
    public AuthenticationCustomCredentialsMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected boolean isOwnerConnection() {
        return ((ClientAuthenticationCustomCodec.RequestParameters)this.parameters).isOwnerConnection;
    }

    @Override
    protected String getClientType() {
        return ((ClientAuthenticationCustomCodec.RequestParameters)this.parameters).clientType;
    }

    @Override
    protected ClientAuthenticationCustomCodec.RequestParameters decodeClientMessage(ClientMessage clientMessage) {
        ClientAuthenticationCustomCodec.RequestParameters parameters = ClientAuthenticationCustomCodec.decodeRequest(clientMessage);
        String uuid = parameters.uuid;
        String ownerUuid = parameters.ownerUuid;
        if (uuid != null && uuid.length() > 0) {
            this.principal = new ClientPrincipal(uuid, ownerUuid);
        }
        this.credentials = (Credentials)this.serializationService.toObject(parameters.credentials);
        this.clientSerializationVersion = parameters.serializationVersion;
        if (parameters.clientNutclusterVersionExist) {
            this.clientVersion = parameters.clientNutclusterVersion;
        }
        if (parameters.clientNameExist) {
            this.clientName = parameters.clientName;
        }
        this.labels = parameters.labelsExist ? Collections.unmodifiableSet(new HashSet<String>(parameters.labels)) : Collections.emptySet();
        this.partitionCount = parameters.partitionCountExist ? parameters.partitionCount : null;
        this.clusterId = parameters.clusterIdExist ? parameters.clusterId : null;
        return parameters;
    }

    @Override
    protected ClientMessage encodeResponse(Object response) {
        return (ClientMessage)response;
    }

    @Override
    protected ClientMessage encodeAuth(byte status, Address thisAddress, String uuid, String ownerUuid, byte version, List<Member> cleanedUpMembers, int partitionCount, String clusterId) {
        return ClientAuthenticationCustomCodec.encodeResponse(status, thisAddress, uuid, ownerUuid, version, this.getMemberBuildInfo().getVersion(), cleanedUpMembers, partitionCount, clusterId);
    }

    @Override
    public String getServiceName() {
        return null;
    }

    @Override
    public String getDistributedObjectName() {
        return null;
    }

    @Override
    public String getMethodName() {
        return null;
    }

    @Override
    public Object[] getParameters() {
        return null;
    }
}

