/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.client.impl.protocol.task.cache;

import com.atlassian.nutcluster.cache.impl.journal.CacheEventJournalReadOperation;
import com.atlassian.nutcluster.client.impl.protocol.ClientMessage;
import com.atlassian.nutcluster.client.impl.protocol.codec.CacheEventJournalReadCodec;
import com.atlassian.nutcluster.client.impl.protocol.task.cache.AbstractCacheMessageTask;
import com.atlassian.nutcluster.instance.Node;
import com.atlassian.nutcluster.nio.Connection;
import com.atlassian.nutcluster.nio.serialization.Data;
import com.atlassian.nutcluster.ringbuffer.impl.ReadResultSetImpl;
import com.atlassian.nutcluster.security.permission.CachePermission;
import com.atlassian.nutcluster.spi.Operation;
import com.atlassian.nutcluster.util.function.Function;
import com.atlassian.nutcluster.util.function.Predicate;
import java.security.Permission;
import java.util.ArrayList;

public class CacheEventJournalReadTask<K, V, T>
extends AbstractCacheMessageTask<CacheEventJournalReadCodec.RequestParameters> {
    public CacheEventJournalReadTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected Operation prepareOperation() {
        Function projection = (Function)this.serializationService.toObject(((CacheEventJournalReadCodec.RequestParameters)this.parameters).projection);
        Predicate predicate = (Predicate)this.serializationService.toObject(((CacheEventJournalReadCodec.RequestParameters)this.parameters).predicate);
        return new CacheEventJournalReadOperation(((CacheEventJournalReadCodec.RequestParameters)this.parameters).name, ((CacheEventJournalReadCodec.RequestParameters)this.parameters).startSequence, ((CacheEventJournalReadCodec.RequestParameters)this.parameters).minSize, ((CacheEventJournalReadCodec.RequestParameters)this.parameters).maxSize, predicate, projection);
    }

    @Override
    protected CacheEventJournalReadCodec.RequestParameters decodeClientMessage(ClientMessage clientMessage) {
        return CacheEventJournalReadCodec.decodeRequest(clientMessage);
    }

    @Override
    protected ClientMessage encodeResponse(Object response) {
        ReadResultSetImpl resultSet = (ReadResultSetImpl)this.nodeEngine.getSerializationService().toObject(response);
        ArrayList<Data> items = new ArrayList<Data>(resultSet.size());
        long[] seqs = new long[resultSet.size()];
        Data[] dataItems = resultSet.getDataItems();
        for (int k = 0; k < resultSet.size(); ++k) {
            items.add(dataItems[k]);
            seqs[k] = resultSet.getSequence(k);
        }
        return CacheEventJournalReadCodec.encodeResponse(resultSet.readCount(), items, seqs, resultSet.getNextSequenceToReadFrom());
    }

    @Override
    public final String getServiceName() {
        return "hz:impl:cacheService";
    }

    @Override
    public Permission getRequiredPermission() {
        return new CachePermission(((CacheEventJournalReadCodec.RequestParameters)this.parameters).name, "read");
    }

    @Override
    public String getDistributedObjectName() {
        return ((CacheEventJournalReadCodec.RequestParameters)this.parameters).name;
    }

    @Override
    public String getMethodName() {
        return "readFromEventJournal";
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{((CacheEventJournalReadCodec.RequestParameters)this.parameters).startSequence, ((CacheEventJournalReadCodec.RequestParameters)this.parameters).maxSize, this.getPartitionId(), ((CacheEventJournalReadCodec.RequestParameters)this.parameters).predicate, ((CacheEventJournalReadCodec.RequestParameters)this.parameters).projection};
    }
}

