/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.client.impl.protocol.task.cache;

import com.atlassian.nutcluster.cache.impl.operation.CacheGetConfigOperation;
import com.atlassian.nutcluster.client.impl.protocol.ClientMessage;
import com.atlassian.nutcluster.client.impl.protocol.codec.CacheGetConfigCodec;
import com.atlassian.nutcluster.client.impl.protocol.task.AbstractAddressMessageTask;
import com.atlassian.nutcluster.config.CacheConfig;
import com.atlassian.nutcluster.config.LegacyCacheConfig;
import com.atlassian.nutcluster.instance.Node;
import com.atlassian.nutcluster.nio.Address;
import com.atlassian.nutcluster.nio.Connection;
import com.atlassian.nutcluster.nio.serialization.Data;
import com.atlassian.nutcluster.security.permission.CachePermission;
import com.atlassian.nutcluster.spi.Operation;
import com.atlassian.nutcluster.spi.properties.GroupProperty;
import java.security.Permission;

public class CacheGetConfigMessageTask
extends AbstractAddressMessageTask<CacheGetConfigCodec.RequestParameters> {
    public CacheGetConfigMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected Address getAddress() {
        return this.nodeEngine.getThisAddress();
    }

    @Override
    protected Operation prepareOperation() {
        return new CacheGetConfigOperation(((CacheGetConfigCodec.RequestParameters)this.parameters).name, ((CacheGetConfigCodec.RequestParameters)this.parameters).simpleName);
    }

    @Override
    public String getServiceName() {
        return "hz:impl:cacheService";
    }

    @Override
    public String getMethodName() {
        return null;
    }

    @Override
    public Object[] getParameters() {
        return null;
    }

    @Override
    public Permission getRequiredPermission() {
        return new CachePermission(((CacheGetConfigCodec.RequestParameters)this.parameters).name, "read");
    }

    @Override
    protected CacheGetConfigCodec.RequestParameters decodeClientMessage(ClientMessage clientMessage) {
        return CacheGetConfigCodec.decodeRequest(clientMessage);
    }

    @Override
    protected ClientMessage encodeResponse(Object response) {
        Data responseData = this.serializeCacheConfig(response);
        return CacheGetConfigCodec.encodeResponse(responseData);
    }

    @Override
    public String getDistributedObjectName() {
        return ((CacheGetConfigCodec.RequestParameters)this.parameters).name;
    }

    private Data serializeCacheConfig(Object response) {
        boolean compatibilityEnabled;
        Data responseData = null;
        if (-1 == this.endpoint.getClientVersion() && (compatibilityEnabled = this.nodeEngine.getProperties().getBoolean(GroupProperty.COMPATIBILITY_3_6_CLIENT_ENABLED))) {
            responseData = this.nodeEngine.toData(response == null ? null : new LegacyCacheConfig((CacheConfig)response));
        }
        if (null == responseData) {
            responseData = this.nodeEngine.toData(response);
        }
        return responseData;
    }
}

