/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.client.impl.protocol.task.cache;

import com.atlassian.nutcluster.cache.impl.CacheKeyIterationResult;
import com.atlassian.nutcluster.cache.impl.CacheOperationProvider;
import com.atlassian.nutcluster.client.impl.protocol.ClientMessage;
import com.atlassian.nutcluster.client.impl.protocol.codec.CacheIterateCodec;
import com.atlassian.nutcluster.client.impl.protocol.task.cache.AbstractCacheMessageTask;
import com.atlassian.nutcluster.instance.Node;
import com.atlassian.nutcluster.nio.Connection;
import com.atlassian.nutcluster.security.permission.CachePermission;
import com.atlassian.nutcluster.spi.Operation;
import java.security.Permission;
import java.util.Collections;

public class CacheIterateMessageTask
extends AbstractCacheMessageTask<CacheIterateCodec.RequestParameters> {
    public CacheIterateMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected Operation prepareOperation() {
        CacheOperationProvider operationProvider = this.getOperationProvider(((CacheIterateCodec.RequestParameters)this.parameters).name);
        return operationProvider.createKeyIteratorOperation(((CacheIterateCodec.RequestParameters)this.parameters).tableIndex, ((CacheIterateCodec.RequestParameters)this.parameters).batch);
    }

    @Override
    protected CacheIterateCodec.RequestParameters decodeClientMessage(ClientMessage clientMessage) {
        return CacheIterateCodec.decodeRequest(clientMessage);
    }

    @Override
    protected ClientMessage encodeResponse(Object response) {
        if (response == null) {
            return CacheIterateCodec.encodeResponse(0, Collections.emptyList());
        }
        CacheKeyIterationResult keyIteratorResult = (CacheKeyIterationResult)response;
        return CacheIterateCodec.encodeResponse(keyIteratorResult.getTableIndex(), keyIteratorResult.getKeys());
    }

    @Override
    public String getDistributedObjectName() {
        return ((CacheIterateCodec.RequestParameters)this.parameters).name;
    }

    @Override
    public Object[] getParameters() {
        return null;
    }

    @Override
    public String getMethodName() {
        return "iterator";
    }

    @Override
    public Permission getRequiredPermission() {
        return new CachePermission(((CacheIterateCodec.RequestParameters)this.parameters).name, "read");
    }
}

