/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.client.impl.protocol.task.map;

import com.atlassian.nutcluster.client.impl.AddInterceptorOperationSupplier;
import com.atlassian.nutcluster.client.impl.protocol.ClientMessage;
import com.atlassian.nutcluster.client.impl.protocol.codec.MapAddInterceptorCodec;
import com.atlassian.nutcluster.client.impl.protocol.task.AbstractMultiTargetMessageTask;
import com.atlassian.nutcluster.core.Member;
import com.atlassian.nutcluster.instance.Node;
import com.atlassian.nutcluster.map.MapInterceptor;
import com.atlassian.nutcluster.map.impl.MapService;
import com.atlassian.nutcluster.map.impl.MapServiceContext;
import com.atlassian.nutcluster.nio.Connection;
import com.atlassian.nutcluster.security.permission.MapPermission;
import com.atlassian.nutcluster.spi.Operation;
import com.atlassian.nutcluster.util.function.Supplier;
import java.security.Permission;
import java.util.Collection;
import java.util.Map;

public class MapAddInterceptorMessageTask
extends AbstractMultiTargetMessageTask<MapAddInterceptorCodec.RequestParameters> {
    private transient String id;

    public MapAddInterceptorMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected Supplier<Operation> createOperationSupplier() {
        MapService mapService = (MapService)this.getService("hz:impl:mapService");
        MapServiceContext mapServiceContext = mapService.getMapServiceContext();
        MapInterceptor mapInterceptor = (MapInterceptor)this.serializationService.toObject(((MapAddInterceptorCodec.RequestParameters)this.parameters).interceptor);
        this.id = mapServiceContext.generateInterceptorId(((MapAddInterceptorCodec.RequestParameters)this.parameters).name, mapInterceptor);
        return new AddInterceptorOperationSupplier(this.id, ((MapAddInterceptorCodec.RequestParameters)this.parameters).name, mapInterceptor);
    }

    @Override
    protected Object reduce(Map<Member, Object> map) throws Throwable {
        for (Object result : map.values()) {
            if (!(result instanceof Throwable)) continue;
            throw (Throwable)result;
        }
        return this.id;
    }

    @Override
    public Collection<Member> getTargets() {
        return this.nodeEngine.getClusterService().getMembers();
    }

    @Override
    protected MapAddInterceptorCodec.RequestParameters decodeClientMessage(ClientMessage clientMessage) {
        return MapAddInterceptorCodec.decodeRequest(clientMessage);
    }

    @Override
    protected ClientMessage encodeResponse(Object response) {
        return MapAddInterceptorCodec.encodeResponse((String)response);
    }

    @Override
    public String getServiceName() {
        return "hz:impl:mapService";
    }

    @Override
    public Permission getRequiredPermission() {
        return new MapPermission(((MapAddInterceptorCodec.RequestParameters)this.parameters).name, "intercept");
    }

    @Override
    public String getDistributedObjectName() {
        return ((MapAddInterceptorCodec.RequestParameters)this.parameters).name;
    }

    @Override
    public String getMethodName() {
        return "addInterceptor";
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{((MapAddInterceptorCodec.RequestParameters)this.parameters).interceptor};
    }
}

