/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.collection.impl.queue.operations;

import com.atlassian.nutcluster.collection.impl.queue.QueueContainer;
import com.atlassian.nutcluster.collection.impl.queue.QueueDataSerializerHook;
import com.atlassian.nutcluster.collection.impl.queue.operations.QueueOperation;
import com.atlassian.nutcluster.nio.ObjectDataInput;
import com.atlassian.nutcluster.nio.ObjectDataOutput;
import com.atlassian.nutcluster.nio.serialization.IdentifiedDataSerializable;
import com.atlassian.nutcluster.spi.BackupOperation;
import java.io.IOException;

public final class PollBackupOperation
extends QueueOperation
implements BackupOperation,
IdentifiedDataSerializable {
    private long itemId;

    public PollBackupOperation() {
    }

    public PollBackupOperation(String name, long itemId) {
        super(name);
        this.itemId = itemId;
    }

    @Override
    public void run() throws Exception {
        QueueContainer queueContainer = this.getContainer();
        queueContainer.pollBackup(this.itemId);
        this.response = Boolean.TRUE;
    }

    @Override
    public int getFactoryId() {
        return QueueDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 4;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeLong(this.itemId);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.itemId = in.readLong();
    }
}

