/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.collection.impl.set;

import com.atlassian.nutcluster.collection.impl.collection.CollectionContainer;
import com.atlassian.nutcluster.collection.impl.collection.CollectionService;
import com.atlassian.nutcluster.collection.impl.set.SetContainer;
import com.atlassian.nutcluster.collection.impl.set.SetProxyImpl;
import com.atlassian.nutcluster.collection.impl.set.operations.SetReplicationOperation;
import com.atlassian.nutcluster.collection.impl.txnset.TransactionalSetProxy;
import com.atlassian.nutcluster.config.SetConfig;
import com.atlassian.nutcluster.core.DistributedObject;
import com.atlassian.nutcluster.spi.NodeEngine;
import com.atlassian.nutcluster.spi.Operation;
import com.atlassian.nutcluster.spi.PartitionReplicationEvent;
import com.atlassian.nutcluster.transaction.impl.Transaction;
import com.atlassian.nutcluster.util.ConcurrencyUtil;
import com.atlassian.nutcluster.util.ConstructorFunction;
import com.atlassian.nutcluster.util.ContextMutexFactory;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class SetService
extends CollectionService {
    public static final String SERVICE_NAME = "hz:impl:setService";
    private static final Object NULL_OBJECT = new Object();
    private final ConcurrentMap<String, SetContainer> containerMap = new ConcurrentHashMap<String, SetContainer>();
    private final ConcurrentMap<String, Object> quorumConfigCache = new ConcurrentHashMap<String, Object>();
    private final ContextMutexFactory quorumConfigCacheMutexFactory = new ContextMutexFactory();
    private final ConstructorFunction<String, Object> quorumConfigConstructor = new ConstructorFunction<String, Object>(){

        @Override
        public Object createNew(String name) {
            SetConfig lockConfig = SetService.this.nodeEngine.getConfig().findSetConfig(name);
            String quorumName = lockConfig.getQuorumName();
            return quorumName == null ? NULL_OBJECT : quorumName;
        }
    };

    public SetService(NodeEngine nodeEngine) {
        super(nodeEngine);
    }

    @Override
    public SetContainer getOrCreateContainer(String name, boolean backup) {
        SetContainer current;
        SetContainer container = (SetContainer)this.containerMap.get(name);
        if (container == null && (current = this.containerMap.putIfAbsent(name, container = new SetContainer(name, this.nodeEngine))) != null) {
            container = current;
        }
        return container;
    }

    @Override
    public ConcurrentMap<String, ? extends CollectionContainer> getContainerMap() {
        return this.containerMap;
    }

    @Override
    public String getServiceName() {
        return SERVICE_NAME;
    }

    @Override
    public DistributedObject createDistributedObject(String objectId) {
        return new SetProxyImpl(objectId, this.nodeEngine, this);
    }

    @Override
    public void destroyDistributedObject(String name) {
        super.destroyDistributedObject(name);
        this.quorumConfigCache.remove(name);
    }

    public TransactionalSetProxy createTransactionalObject(String name, Transaction transaction) {
        return new TransactionalSetProxy(name, transaction, this.nodeEngine, this);
    }

    @Override
    public Operation prepareReplicationOperation(PartitionReplicationEvent event) {
        Map<String, CollectionContainer> migrationData = this.getMigrationData(event);
        return migrationData.isEmpty() ? null : new SetReplicationOperation(migrationData, event.getPartitionId(), event.getReplicaIndex());
    }

    @Override
    public String getQuorumName(String name) {
        Object quorumName = ConcurrencyUtil.getOrPutSynchronized(this.quorumConfigCache, name, this.quorumConfigCacheMutexFactory, this.quorumConfigConstructor);
        return quorumName == NULL_OBJECT ? null : (String)quorumName;
    }
}

