/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.collection.impl.txnqueue.operations;

import com.atlassian.nutcluster.collection.impl.queue.QueueContainer;
import com.atlassian.nutcluster.collection.impl.txnqueue.operations.BaseTxnQueueOperation;
import com.atlassian.nutcluster.collection.impl.txnqueue.operations.TxnOfferBackupOperation;
import com.atlassian.nutcluster.core.ItemEventType;
import com.atlassian.nutcluster.monitor.impl.LocalQueueStatsImpl;
import com.atlassian.nutcluster.nio.ObjectDataInput;
import com.atlassian.nutcluster.nio.ObjectDataOutput;
import com.atlassian.nutcluster.nio.serialization.Data;
import com.atlassian.nutcluster.spi.Notifier;
import com.atlassian.nutcluster.spi.Operation;
import com.atlassian.nutcluster.spi.WaitNotifyKey;
import com.atlassian.nutcluster.spi.impl.MutatingOperation;
import java.io.IOException;

public class TxnOfferOperation
extends BaseTxnQueueOperation
implements Notifier,
MutatingOperation {
    private Data data;

    public TxnOfferOperation() {
    }

    public TxnOfferOperation(String name, long itemId, Data data) {
        super(name, itemId);
        this.data = data;
    }

    @Override
    public void run() throws Exception {
        QueueContainer createContainer = this.getContainer();
        this.response = createContainer.txnCommitOffer(this.getItemId(), this.data, false);
    }

    @Override
    public void afterRun() throws Exception {
        LocalQueueStatsImpl queueStats = this.getQueueService().getLocalQueueStatsImpl(this.name);
        if (Boolean.TRUE.equals(this.response)) {
            queueStats.incrementOffers();
            this.publishEvent(ItemEventType.ADDED, this.data);
        } else {
            queueStats.incrementRejectedOffers();
        }
    }

    @Override
    public boolean shouldBackup() {
        return Boolean.TRUE.equals(this.response);
    }

    @Override
    public Operation getBackupOperation() {
        return new TxnOfferBackupOperation(this.name, this.getItemId(), this.data);
    }

    @Override
    public boolean shouldNotify() {
        return Boolean.TRUE.equals(this.response);
    }

    @Override
    public WaitNotifyKey getNotifiedKey() {
        return this.getContainer().getPollWaitNotifyKey();
    }

    @Override
    public boolean isRemoveOperation() {
        return false;
    }

    @Override
    public int getId() {
        return 24;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeData(this.data);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.data = in.readData();
    }
}

