/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.collection.impl.txnqueue.operations;

import com.atlassian.nutcluster.collection.impl.CollectionTxnUtil;
import com.atlassian.nutcluster.collection.impl.queue.QueueContainer;
import com.atlassian.nutcluster.collection.impl.queue.operations.QueueOperation;
import com.atlassian.nutcluster.nio.ObjectDataInput;
import com.atlassian.nutcluster.nio.ObjectDataOutput;
import com.atlassian.nutcluster.spi.BackupOperation;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;

public class TxnRollbackBackupOperation
extends QueueOperation
implements BackupOperation {
    private long[] itemIds;

    public TxnRollbackBackupOperation() {
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public TxnRollbackBackupOperation(String name, long[] itemIds) {
        super(name);
        this.itemIds = itemIds;
    }

    @Override
    public void run() throws Exception {
        QueueContainer queueContainer = this.getContainer();
        for (long itemId : this.itemIds) {
            this.response = CollectionTxnUtil.isRemove(itemId) ? Boolean.valueOf(queueContainer.txnRollbackPoll(itemId, true)) : Boolean.valueOf(queueContainer.txnRollbackOfferBackup(-itemId));
        }
    }

    @Override
    public int getId() {
        return 33;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeLongArray(this.itemIds);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.itemIds = in.readLongArray();
    }
}

