/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.collection.impl.txnset;

import com.atlassian.nutcluster.collection.impl.collection.CollectionItem;
import com.atlassian.nutcluster.collection.impl.set.SetService;
import com.atlassian.nutcluster.collection.impl.txncollection.AbstractTransactionalCollectionProxy;
import com.atlassian.nutcluster.collection.impl.txncollection.operations.CollectionReserveAddOperation;
import com.atlassian.nutcluster.collection.impl.txncollection.operations.CollectionTxnAddOperation;
import com.atlassian.nutcluster.core.TransactionalSet;
import com.atlassian.nutcluster.nio.serialization.Data;
import com.atlassian.nutcluster.spi.InternalCompletableFuture;
import com.atlassian.nutcluster.spi.NodeEngine;
import com.atlassian.nutcluster.transaction.TransactionException;
import com.atlassian.nutcluster.transaction.impl.Transaction;
import com.atlassian.nutcluster.util.ExceptionUtil;
import java.util.Collection;
import java.util.HashSet;

public class TransactionalSetProxy<E>
extends AbstractTransactionalCollectionProxy<SetService, E>
implements TransactionalSet<E> {
    private final HashSet<CollectionItem> set = new HashSet();

    public TransactionalSetProxy(String name, Transaction tx, NodeEngine nodeEngine, SetService service) {
        super(name, tx, nodeEngine, service);
    }

    @Override
    public boolean add(E e) {
        this.checkTransactionActive();
        this.checkObjectNotNull(e);
        Data value = this.getNodeEngine().toData(e);
        if (!this.getCollection().add(new CollectionItem(-1L, value))) {
            return false;
        }
        CollectionReserveAddOperation operation = new CollectionReserveAddOperation(this.name, this.tx.getTxnId(), value);
        try {
            InternalCompletableFuture future = this.operationService.invokeOnPartition(this.getServiceName(), operation, this.partitionId);
            Long itemId = (Long)future.get();
            if (itemId != null) {
                if (!this.itemIdSet.add(itemId)) {
                    throw new TransactionException("Duplicate itemId: " + itemId);
                }
                CollectionTxnAddOperation op = new CollectionTxnAddOperation(this.name, itemId, value);
                this.putToRecord(op);
                return true;
            }
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
        return false;
    }

    @Override
    public String getServiceName() {
        return "hz:impl:setService";
    }

    @Override
    protected Collection<CollectionItem> getCollection() {
        return this.set;
    }
}

