/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.concurrent.atomiclong.operations;

import com.atlassian.nutcluster.concurrent.atomiclong.AtomicLongContainer;
import com.atlassian.nutcluster.concurrent.atomiclong.AtomicLongService;
import com.atlassian.nutcluster.concurrent.atomiclong.operations.AbstractAtomicLongOperation;
import com.atlassian.nutcluster.nio.ObjectDataInput;
import com.atlassian.nutcluster.nio.ObjectDataOutput;
import com.atlassian.nutcluster.spi.BackupOperation;
import java.io.IOException;

public class MergeBackupOperation
extends AbstractAtomicLongOperation
implements BackupOperation {
    private Long newValue;

    public MergeBackupOperation() {
    }

    public MergeBackupOperation(String name, Long newValue) {
        super(name);
        this.newValue = newValue;
    }

    @Override
    public void run() throws Exception {
        if (this.newValue == null) {
            AtomicLongService service = (AtomicLongService)this.getService();
            service.destroyDistributedObject(this.name);
        } else {
            AtomicLongContainer container = this.getLongContainer();
            container.set(this.newValue);
        }
    }

    @Override
    public int getId() {
        return 14;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject(this.newValue);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.newValue = (Long)in.readObject();
    }
}

