/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.concurrent.atomicreference.operations;

import com.atlassian.nutcluster.concurrent.atomicreference.AtomicReferenceContainer;
import com.atlassian.nutcluster.concurrent.atomicreference.operations.AtomicReferenceBackupAwareOperation;
import com.atlassian.nutcluster.concurrent.atomicreference.operations.SetBackupOperation;
import com.atlassian.nutcluster.nio.ObjectDataInput;
import com.atlassian.nutcluster.nio.ObjectDataOutput;
import com.atlassian.nutcluster.nio.serialization.Data;
import com.atlassian.nutcluster.spi.Operation;
import com.atlassian.nutcluster.spi.impl.MutatingOperation;
import java.io.IOException;

public class CompareAndSetOperation
extends AtomicReferenceBackupAwareOperation
implements MutatingOperation {
    private Data expect;
    private Data update;
    private boolean returnValue;

    public CompareAndSetOperation() {
    }

    public CompareAndSetOperation(String name, Data expect, Data update) {
        super(name);
        this.expect = expect;
        this.update = update;
    }

    @Override
    public void run() throws Exception {
        AtomicReferenceContainer container = this.getReferenceContainer();
        this.shouldBackup = this.returnValue = container.compareAndSet(this.expect, this.update);
    }

    @Override
    public Object getResponse() {
        return this.returnValue;
    }

    @Override
    public boolean shouldBackup() {
        return this.shouldBackup;
    }

    @Override
    public Operation getBackupOperation() {
        return new SetBackupOperation(this.name, this.update);
    }

    @Override
    public int getId() {
        return 3;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeData(this.expect);
        out.writeData(this.update);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.expect = in.readData();
        this.update = in.readData();
    }
}

