/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.concurrent.atomicreference.operations;

import com.atlassian.nutcluster.concurrent.atomicreference.AtomicReferenceContainer;
import com.atlassian.nutcluster.concurrent.atomicreference.operations.AtomicReferenceBackupAwareOperation;
import com.atlassian.nutcluster.concurrent.atomicreference.operations.SetBackupOperation;
import com.atlassian.nutcluster.nio.ObjectDataInput;
import com.atlassian.nutcluster.nio.ObjectDataOutput;
import com.atlassian.nutcluster.nio.serialization.Data;
import com.atlassian.nutcluster.spi.Operation;
import com.atlassian.nutcluster.spi.impl.MutatingOperation;
import java.io.IOException;

public class GetAndSetOperation
extends AtomicReferenceBackupAwareOperation
implements MutatingOperation {
    private Data newValue;
    private Data returnValue;

    public GetAndSetOperation() {
    }

    public GetAndSetOperation(String name, Data newValue) {
        super(name);
        this.newValue = newValue;
    }

    @Override
    public void run() throws Exception {
        AtomicReferenceContainer container = this.getReferenceContainer();
        this.returnValue = container.getAndSet(this.newValue);
    }

    @Override
    public Object getResponse() {
        return this.returnValue;
    }

    @Override
    public Operation getBackupOperation() {
        return new SetBackupOperation(this.name, this.newValue);
    }

    @Override
    public int getId() {
        return 6;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeData(this.newValue);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.newValue = in.readData();
    }
}

