/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.concurrent.lock.operations;

import com.atlassian.nutcluster.concurrent.lock.LockResourceImpl;
import com.atlassian.nutcluster.concurrent.lock.LockStoreImpl;
import com.atlassian.nutcluster.concurrent.lock.operations.UnlockOperation;
import com.atlassian.nutcluster.logging.ILogger;
import com.atlassian.nutcluster.nio.ObjectDataInput;
import com.atlassian.nutcluster.nio.ObjectDataOutput;
import com.atlassian.nutcluster.nio.serialization.Data;
import com.atlassian.nutcluster.spi.BackupAwareOperation;
import com.atlassian.nutcluster.spi.NodeEngine;
import com.atlassian.nutcluster.spi.Notifier;
import com.atlassian.nutcluster.spi.ObjectNamespace;
import com.atlassian.nutcluster.spi.impl.QuorumCheckAwareOperation;
import com.atlassian.nutcluster.spi.partition.IPartition;
import com.atlassian.nutcluster.spi.partition.IPartitionService;
import java.io.IOException;

public class LocalLockCleanupOperation
extends UnlockOperation
implements Notifier,
BackupAwareOperation,
QuorumCheckAwareOperation {
    private final String uuid;

    public LocalLockCleanupOperation() {
        this.uuid = "";
    }

    public LocalLockCleanupOperation(ObjectNamespace namespace, Data key, String uuid) {
        super(namespace, key, -1L, true);
        this.uuid = uuid;
    }

    @Override
    public void run() throws Exception {
        LockStoreImpl lockStore = this.getLockStore();
        LockResourceImpl lock = lockStore.getLock(this.key);
        if (this.uuid.equals(lock.getOwner())) {
            ILogger logger = this.getLogger();
            if (logger.isFinestEnabled()) {
                logger.finest("Unlocking lock owned by UUID: " + this.uuid + ", thread ID: " + lock.getThreadId() + ", count: " + lock.getLockCount());
            }
            this.response = lockStore.forceUnlock(this.key);
        }
    }

    @Override
    public boolean shouldBackup() {
        NodeEngine nodeEngine = this.getNodeEngine();
        IPartitionService partitionService = nodeEngine.getPartitionService();
        IPartition partition = partitionService.getPartition(this.getPartitionId());
        return partition.isLocal() && Boolean.TRUE.equals(this.response);
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        throw new UnsupportedOperationException("LocalLockCleanupOperation is local only.");
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        throw new UnsupportedOperationException("LocalLockCleanupOperation is local only.");
    }

    @Override
    public int getId() {
        throw new UnsupportedOperationException("LocalLockCleanupOperation is local only.");
    }

    @Override
    public boolean shouldCheckQuorum() {
        return false;
    }
}

