/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.concurrent.semaphore;

import com.atlassian.nutcluster.concurrent.semaphore.SemaphoreContainer;
import com.atlassian.nutcluster.concurrent.semaphore.SemaphoreProxy;
import com.atlassian.nutcluster.concurrent.semaphore.operations.SemaphoreDetachMemberOperation;
import com.atlassian.nutcluster.concurrent.semaphore.operations.SemaphoreReplicationOperation;
import com.atlassian.nutcluster.config.SemaphoreConfig;
import com.atlassian.nutcluster.partition.strategy.StringPartitioningStrategy;
import com.atlassian.nutcluster.spi.ClientAwareService;
import com.atlassian.nutcluster.spi.ManagedService;
import com.atlassian.nutcluster.spi.MemberAttributeServiceEvent;
import com.atlassian.nutcluster.spi.MembershipAwareService;
import com.atlassian.nutcluster.spi.MembershipServiceEvent;
import com.atlassian.nutcluster.spi.MigrationAwareService;
import com.atlassian.nutcluster.spi.NodeEngine;
import com.atlassian.nutcluster.spi.Operation;
import com.atlassian.nutcluster.spi.OperationService;
import com.atlassian.nutcluster.spi.PartitionMigrationEvent;
import com.atlassian.nutcluster.spi.PartitionReplicationEvent;
import com.atlassian.nutcluster.spi.QuorumAwareService;
import com.atlassian.nutcluster.spi.RemoteService;
import com.atlassian.nutcluster.spi.partition.IPartitionService;
import com.atlassian.nutcluster.spi.partition.MigrationEndpoint;
import com.atlassian.nutcluster.util.ConcurrencyUtil;
import com.atlassian.nutcluster.util.ConstructorFunction;
import com.atlassian.nutcluster.util.ContextMutexFactory;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class SemaphoreService
implements ManagedService,
MigrationAwareService,
MembershipAwareService,
RemoteService,
ClientAwareService,
QuorumAwareService {
    public static final String SERVICE_NAME = "hz:impl:semaphoreService";
    private static final Object NULL_OBJECT = new Object();
    private final ConcurrentMap<String, SemaphoreContainer> containers = new ConcurrentHashMap<String, SemaphoreContainer>();
    private final ConcurrentMap<String, Object> quorumConfigCache = new ConcurrentHashMap<String, Object>();
    private final ContextMutexFactory quorumConfigCacheMutexFactory = new ContextMutexFactory();
    private final ConstructorFunction<String, Object> quorumConfigConstructor = new ConstructorFunction<String, Object>(){

        @Override
        public Object createNew(String name) {
            SemaphoreConfig semaphoreConfig = SemaphoreService.this.nodeEngine.getConfig().findSemaphoreConfig(name);
            String quorumName = semaphoreConfig.getQuorumName();
            return quorumName == null ? NULL_OBJECT : quorumName;
        }
    };
    private final ConstructorFunction<String, SemaphoreContainer> containerConstructor = new ConstructorFunction<String, SemaphoreContainer>(){

        @Override
        public SemaphoreContainer createNew(String name) {
            SemaphoreConfig config = SemaphoreService.this.nodeEngine.getConfig().findSemaphoreConfig(name);
            IPartitionService partitionService = SemaphoreService.this.nodeEngine.getPartitionService();
            int partitionId = partitionService.getPartitionId(StringPartitioningStrategy.getPartitionKey(name));
            return new SemaphoreContainer(partitionId, new SemaphoreConfig(config));
        }
    };
    private final NodeEngine nodeEngine;

    public SemaphoreService(NodeEngine nodeEngine) {
        this.nodeEngine = nodeEngine;
    }

    public SemaphoreContainer getSemaphoreContainer(String name) {
        return ConcurrencyUtil.getOrPutIfAbsent(this.containers, name, this.containerConstructor);
    }

    public boolean containsSemaphore(String name) {
        return this.containers.containsKey(name);
    }

    @Override
    public void init(NodeEngine nodeEngine, Properties properties) {
    }

    @Override
    public void reset() {
        this.containers.clear();
    }

    @Override
    public void shutdown(boolean terminate) {
        this.containers.clear();
    }

    @Override
    public void memberAdded(MembershipServiceEvent event) {
    }

    @Override
    public void memberRemoved(MembershipServiceEvent event) {
        this.onOwnerDisconnected(event.getMember().getUuid());
    }

    @Override
    public void memberAttributeChanged(MemberAttributeServiceEvent event) {
    }

    private void onOwnerDisconnected(String owner) {
        OperationService operationService = this.nodeEngine.getOperationService();
        for (Map.Entry entry : this.containers.entrySet()) {
            String name = (String)entry.getKey();
            SemaphoreContainer container = (SemaphoreContainer)entry.getValue();
            Operation op = new SemaphoreDetachMemberOperation(name, owner).setPartitionId(container.getPartitionId()).setValidateTarget(false).setService(this).setNodeEngine(this.nodeEngine).setServiceName(SERVICE_NAME);
            operationService.invokeOnTarget(SERVICE_NAME, op, this.nodeEngine.getThisAddress());
        }
    }

    @Override
    public SemaphoreProxy createDistributedObject(String objectId) {
        return new SemaphoreProxy(objectId, this, this.nodeEngine);
    }

    @Override
    public void destroyDistributedObject(String objectId) {
        this.containers.remove(objectId);
        this.quorumConfigCache.remove(objectId);
    }

    @Override
    public void beforeMigration(PartitionMigrationEvent partitionMigrationEvent) {
    }

    @Override
    public Operation prepareReplicationOperation(PartitionReplicationEvent event) {
        HashMap<String, SemaphoreContainer> migrationData = new HashMap<String, SemaphoreContainer>();
        for (Map.Entry entry : this.containers.entrySet()) {
            String name = (String)entry.getKey();
            SemaphoreContainer semaphoreContainer = (SemaphoreContainer)entry.getValue();
            if (semaphoreContainer.getPartitionId() != event.getPartitionId() || semaphoreContainer.getTotalBackupCount() < event.getReplicaIndex()) continue;
            migrationData.put(name, semaphoreContainer);
        }
        if (migrationData.isEmpty()) {
            return null;
        }
        return new SemaphoreReplicationOperation(migrationData);
    }

    public void insertMigrationData(Map<String, SemaphoreContainer> migrationData) {
        this.containers.putAll(migrationData);
    }

    @Override
    public void commitMigration(PartitionMigrationEvent event) {
        if (event.getMigrationEndpoint() == MigrationEndpoint.SOURCE) {
            this.clearSemaphoresHavingLesserBackupCountThan(event.getPartitionId(), event.getNewReplicaIndex());
        }
    }

    @Override
    public void rollbackMigration(PartitionMigrationEvent event) {
        if (event.getMigrationEndpoint() == MigrationEndpoint.DESTINATION) {
            this.clearSemaphoresHavingLesserBackupCountThan(event.getPartitionId(), event.getCurrentReplicaIndex());
        }
    }

    private void clearSemaphoresHavingLesserBackupCountThan(int partitionId, int thresholdReplicaIndex) {
        Iterator it = this.containers.values().iterator();
        while (it.hasNext()) {
            SemaphoreContainer semaphoreContainer = (SemaphoreContainer)it.next();
            if (semaphoreContainer.getPartitionId() != partitionId || thresholdReplicaIndex >= 0 && thresholdReplicaIndex <= semaphoreContainer.getTotalBackupCount()) continue;
            it.remove();
        }
    }

    @Override
    public void clientDisconnected(String clientUuid) {
        this.onOwnerDisconnected(clientUuid);
    }

    @Override
    public String getQuorumName(String name) {
        Object quorumName = ConcurrencyUtil.getOrPutSynchronized(this.quorumConfigCache, name, this.quorumConfigCacheMutexFactory, this.quorumConfigConstructor);
        return quorumName == NULL_OBJECT ? null : (String)quorumName;
    }
}

