/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.concurrent.semaphore.operations;

import com.atlassian.nutcluster.concurrent.semaphore.SemaphoreContainer;
import com.atlassian.nutcluster.concurrent.semaphore.SemaphoreWaitNotifyKey;
import com.atlassian.nutcluster.concurrent.semaphore.operations.AcquireBackupOperation;
import com.atlassian.nutcluster.concurrent.semaphore.operations.SemaphoreBackupAwareOperation;
import com.atlassian.nutcluster.spi.BlockingOperation;
import com.atlassian.nutcluster.spi.Operation;
import com.atlassian.nutcluster.spi.WaitNotifyKey;
import com.atlassian.nutcluster.spi.impl.MutatingOperation;

public class AcquireOperation
extends SemaphoreBackupAwareOperation
implements BlockingOperation,
MutatingOperation {
    public AcquireOperation() {
    }

    public AcquireOperation(String name, int permitCount, long timeout) {
        super(name, permitCount);
        this.setWaitTimeout(timeout);
    }

    @Override
    public void run() throws Exception {
        SemaphoreContainer semaphoreContainer = this.getSemaphoreContainer();
        this.response = semaphoreContainer.acquire(this.getCallerUuid(), this.permitCount);
    }

    @Override
    public WaitNotifyKey getWaitKey() {
        return new SemaphoreWaitNotifyKey(this.name, "acquire");
    }

    @Override
    public boolean shouldWait() {
        SemaphoreContainer semaphoreContainer = this.getSemaphoreContainer();
        return this.getWaitTimeout() != 0L && !semaphoreContainer.isAvailable(this.permitCount);
    }

    @Override
    public void onWaitExpire() {
        this.sendResponse(false);
    }

    @Override
    public boolean shouldBackup() {
        return Boolean.TRUE.equals(this.response);
    }

    @Override
    public Operation getBackupOperation() {
        return new AcquireBackupOperation(this.name, this.permitCount, this.getCallerUuid());
    }

    @Override
    public int getId() {
        return 2;
    }
}

