/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.concurrent.semaphore.operations;

import com.atlassian.nutcluster.concurrent.semaphore.SemaphoreContainer;
import com.atlassian.nutcluster.concurrent.semaphore.SemaphoreDataSerializerHook;
import com.atlassian.nutcluster.concurrent.semaphore.SemaphoreService;
import com.atlassian.nutcluster.nio.ObjectDataInput;
import com.atlassian.nutcluster.nio.ObjectDataOutput;
import com.atlassian.nutcluster.nio.serialization.IdentifiedDataSerializable;
import com.atlassian.nutcluster.spi.PartitionAwareOperation;
import com.atlassian.nutcluster.spi.impl.AbstractNamedOperation;
import java.io.IOException;

public abstract class SemaphoreOperation
extends AbstractNamedOperation
implements PartitionAwareOperation,
IdentifiedDataSerializable {
    protected int permitCount;
    protected transient Object response;

    protected SemaphoreOperation() {
    }

    protected SemaphoreOperation(String name, int permitCount) {
        super(name);
        this.permitCount = permitCount;
    }

    @Override
    public String getServiceName() {
        return "hz:impl:semaphoreService";
    }

    @Override
    public Object getResponse() {
        return this.response;
    }

    public SemaphoreContainer getSemaphoreContainer() {
        SemaphoreService service = (SemaphoreService)this.getService();
        return service.getSemaphoreContainer(this.name);
    }

    @Override
    public final int getFactoryId() {
        return SemaphoreDataSerializerHook.F_ID;
    }

    @Override
    public void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeInt(this.permitCount);
    }

    @Override
    public void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.permitCount = in.readInt();
    }
}

