/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.config;

import com.atlassian.nutcluster.config.Config;
import com.atlassian.nutcluster.config.YamlConfigBuilder;
import com.atlassian.nutcluster.logging.ILogger;
import com.atlassian.nutcluster.logging.Logger;
import com.atlassian.nutcluster.util.Preconditions;
import java.io.InputStream;
import java.util.Properties;

public class ClasspathYamlConfig
extends Config {
    private static final ILogger LOGGER = Logger.getLogger(ClasspathYamlConfig.class);

    public ClasspathYamlConfig(String resource) {
        this(resource, System.getProperties());
    }

    public ClasspathYamlConfig(String resource, Properties properties) {
        this(Thread.currentThread().getContextClassLoader(), resource, properties);
    }

    public ClasspathYamlConfig(ClassLoader classLoader, String resource) {
        this(classLoader, resource, System.getProperties());
    }

    public ClasspathYamlConfig(ClassLoader classLoader, String resource, Properties properties) {
        Preconditions.checkTrue(classLoader != null, "classLoader can't be null");
        Preconditions.checkTrue(resource != null, "resource can't be null");
        Preconditions.checkTrue(properties != null, "properties can't be null");
        LOGGER.info("Configuring Nutcluster from '" + resource + "'.");
        InputStream in = classLoader.getResourceAsStream(resource);
        Preconditions.checkTrue(in != null, "Specified resource '" + resource + "' could not be found!");
        new YamlConfigBuilder(in).setProperties(properties).build(this);
    }
}

