/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.config;

import com.atlassian.nutcluster.config.Config;
import com.atlassian.nutcluster.config.YamlConfigBuilder;
import com.atlassian.nutcluster.logging.ILogger;
import com.atlassian.nutcluster.logging.Logger;
import com.atlassian.nutcluster.util.Preconditions;
import com.atlassian.nutcluster.util.StringUtil;
import java.io.ByteArrayInputStream;
import java.util.Properties;

public class InMemoryYamlConfig
extends Config {
    private static final ILogger LOGGER = Logger.getLogger(InMemoryYamlConfig.class);

    public InMemoryYamlConfig(String yaml) {
        this(yaml, System.getProperties());
    }

    public InMemoryYamlConfig(String yaml, Properties properties) {
        LOGGER.info("Configuring Nutcluster from 'in-memory YAML'.");
        if (StringUtil.isNullOrEmptyAfterTrim(yaml)) {
            throw new IllegalArgumentException("YAML configuration is null or empty! Please use a well-structured YAML.");
        }
        Preconditions.checkTrue(properties != null, "properties can't be null");
        ByteArrayInputStream in = new ByteArrayInputStream(StringUtil.stringToBytes(yaml));
        new YamlConfigBuilder(in).setProperties(properties).build(this);
    }
}

