/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.config;

import com.atlassian.nutcluster.config.CacheEvictionConfig;
import com.atlassian.nutcluster.config.EvictionConfig;
import com.atlassian.nutcluster.config.EvictionPolicy;
import com.atlassian.nutcluster.nio.ObjectDataInput;
import com.atlassian.nutcluster.nio.ObjectDataOutput;
import com.atlassian.nutcluster.nio.serialization.BinaryInterface;
import com.atlassian.nutcluster.nio.serialization.TypedDataSerializable;
import java.io.IOException;

@BinaryInterface
public class LegacyCacheEvictionConfig
implements TypedDataSerializable {
    final CacheEvictionConfig config;

    public LegacyCacheEvictionConfig() {
        this.config = new CacheEvictionConfig();
    }

    public LegacyCacheEvictionConfig(CacheEvictionConfig evictionConfig) {
        this.config = evictionConfig;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeInt(this.config.getSize());
        out.writeUTF(this.config.getMaxSizePolicy().toString());
        out.writeUTF(this.config.getEvictionPolicy().toString());
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.config.setSize(in.readInt());
        this.config.setMaximumSizePolicy(EvictionConfig.MaxSizePolicy.valueOf(in.readUTF()));
        this.config.setEvictionPolicy(EvictionPolicy.valueOf(in.readUTF()));
    }

    @Override
    public Class getClassType() {
        return CacheEvictionConfig.class;
    }

    public CacheEvictionConfig getConfig() {
        return this.config;
    }
}

