/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.core;

import com.atlassian.nutcluster.core.DistributedObject;
import com.atlassian.nutcluster.spi.exception.DistributedObjectDestroyedException;

public class DistributedObjectEvent {
    protected DistributedObject distributedObject;
    private EventType eventType;
    private String serviceName;
    private String objectName;

    public DistributedObjectEvent(EventType eventType, String serviceName, String objectName, DistributedObject distributedObject) {
        this.eventType = eventType;
        this.serviceName = serviceName;
        this.objectName = objectName;
        this.distributedObject = distributedObject;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public EventType getEventType() {
        return this.eventType;
    }

    public Object getObjectId() {
        return this.getObjectName();
    }

    public Object getObjectName() {
        return this.objectName;
    }

    public DistributedObject getDistributedObject() {
        if (EventType.DESTROYED.equals((Object)this.eventType)) {
            throw new DistributedObjectDestroyedException(this.objectName + " destroyed!");
        }
        return this.distributedObject;
    }

    public String toString() {
        return "DistributedObjectEvent{eventType=" + String.valueOf((Object)this.eventType) + ", serviceName='" + this.serviceName + "', objectName='" + this.objectName + "', distributedObject=" + String.valueOf(this.distributedObject) + "}";
    }

    public static enum EventType {
        CREATED,
        DESTROYED;

    }
}

