/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.cp.internal.client;

import com.atlassian.nutcluster.client.impl.protocol.ClientMessage;
import com.atlassian.nutcluster.client.impl.protocol.task.AbstractMessageTask;
import com.atlassian.nutcluster.core.ExecutionCallback;
import com.atlassian.nutcluster.cp.CPGroupId;
import com.atlassian.nutcluster.cp.internal.RaftInvocationManager;
import com.atlassian.nutcluster.cp.internal.RaftOp;
import com.atlassian.nutcluster.cp.internal.RaftService;
import com.atlassian.nutcluster.cp.internal.raft.QueryPolicy;
import com.atlassian.nutcluster.instance.Node;
import com.atlassian.nutcluster.nio.Connection;
import com.atlassian.nutcluster.spi.InternalCompletableFuture;

public abstract class AbstractCPMessageTask<P>
extends AbstractMessageTask<P>
implements ExecutionCallback<Object> {
    protected AbstractCPMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    protected void query(CPGroupId groupId, RaftOp op, QueryPolicy policy) {
        RaftInvocationManager invocationManager = this.getInvocationManager();
        InternalCompletableFuture future = invocationManager.query(groupId, op, policy, false);
        future.andThen(this);
    }

    protected void invoke(CPGroupId groupId, RaftOp op) {
        RaftInvocationManager invocationManager = this.getInvocationManager();
        InternalCompletableFuture future = invocationManager.invoke(groupId, op, false);
        future.andThen(this);
    }

    private RaftInvocationManager getInvocationManager() {
        RaftService service = (RaftService)this.nodeEngine.getService("hz:core:raft");
        return service.getInvocationManager();
    }

    @Override
    public void onResponse(Object response) {
        this.sendResponse(response);
    }

    @Override
    public void onFailure(Throwable t) {
        this.handleProcessingFailure(t);
    }
}

