/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.cp.internal.operation;

import com.atlassian.nutcluster.core.Endpoint;
import com.atlassian.nutcluster.core.ExecutionCallback;
import com.atlassian.nutcluster.core.ICompletableFuture;
import com.atlassian.nutcluster.cp.CPGroupId;
import com.atlassian.nutcluster.cp.exception.CPGroupDestroyedException;
import com.atlassian.nutcluster.cp.exception.NotLeaderException;
import com.atlassian.nutcluster.cp.internal.IndeterminateOperationStateAware;
import com.atlassian.nutcluster.cp.internal.RaftNodeAware;
import com.atlassian.nutcluster.cp.internal.RaftOp;
import com.atlassian.nutcluster.cp.internal.RaftService;
import com.atlassian.nutcluster.cp.internal.RaftServiceDataSerializerHook;
import com.atlassian.nutcluster.cp.internal.RaftSystemOperation;
import com.atlassian.nutcluster.cp.internal.raft.QueryPolicy;
import com.atlassian.nutcluster.cp.internal.raft.impl.RaftNode;
import com.atlassian.nutcluster.cp.internal.raft.impl.RaftNodeStatus;
import com.atlassian.nutcluster.nio.ObjectDataInput;
import com.atlassian.nutcluster.nio.ObjectDataOutput;
import com.atlassian.nutcluster.nio.serialization.IdentifiedDataSerializable;
import com.atlassian.nutcluster.spi.Operation;
import java.io.IOException;

public class RaftQueryOp
extends Operation
implements IndeterminateOperationStateAware,
RaftSystemOperation,
ExecutionCallback,
IdentifiedDataSerializable {
    private CPGroupId groupId;
    private QueryPolicy queryPolicy;
    private Object op;

    public RaftQueryOp() {
    }

    public RaftQueryOp(CPGroupId groupId, RaftOp raftOp, QueryPolicy queryPolicy) {
        this.groupId = groupId;
        this.op = raftOp;
        this.queryPolicy = queryPolicy;
    }

    @Override
    public final void run() {
        RaftService service = (RaftService)this.getService();
        RaftNode raftNode = service.getRaftNode(this.groupId);
        if (raftNode == null) {
            if (service.isRaftGroupDestroyed(this.groupId)) {
                this.sendResponse(new CPGroupDestroyedException(this.groupId));
            } else {
                this.sendResponse(new NotLeaderException(this.groupId, (Endpoint)service.getLocalCPMember(), null));
            }
            return;
        }
        if (raftNode.getStatus() == RaftNodeStatus.STEPPED_DOWN) {
            service.stepDownRaftNode(this.groupId);
            this.sendResponse(new NotLeaderException(this.groupId, (Endpoint)service.getLocalCPMember(), null));
            return;
        }
        if (this.op instanceof RaftNodeAware) {
            ((RaftNodeAware)this.op).setRaftNode(raftNode);
        }
        ICompletableFuture future = raftNode.query(this.op, this.queryPolicy);
        future.andThen(this);
    }

    @Override
    public boolean isRetryableOnIndeterminateOperationState() {
        return true;
    }

    public void onResponse(Object response) {
        this.sendResponse(response);
    }

    @Override
    public void onFailure(Throwable t) {
        this.sendResponse(t);
    }

    @Override
    public final boolean returnsResponse() {
        return false;
    }

    @Override
    public final boolean validatesTarget() {
        return false;
    }

    @Override
    public final String getServiceName() {
        return "hz:core:raft";
    }

    @Override
    public int getFactoryId() {
        return RaftServiceDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 20;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject(this.groupId);
        out.writeObject(this.op);
        out.writeUTF(this.queryPolicy.toString());
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.groupId = (CPGroupId)in.readObject();
        this.op = in.readObject();
        this.queryPolicy = QueryPolicy.valueOf(in.readUTF());
    }

    @Override
    protected void toString(StringBuilder sb) {
        super.toString(sb);
        sb.append(", op=").append(this.op).append(", groupId=").append(this.groupId).append(", policy=").append((Object)this.queryPolicy);
    }
}

