/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.cp.internal.raftop;

import com.atlassian.nutcluster.core.Endpoint;
import com.atlassian.nutcluster.cp.CPGroupId;
import com.atlassian.nutcluster.cp.internal.IndeterminateOperationStateAware;
import com.atlassian.nutcluster.cp.internal.RaftNodeAware;
import com.atlassian.nutcluster.cp.internal.RaftOp;
import com.atlassian.nutcluster.cp.internal.RaftServiceDataSerializerHook;
import com.atlassian.nutcluster.cp.internal.raft.impl.RaftNode;
import com.atlassian.nutcluster.nio.ObjectDataInput;
import com.atlassian.nutcluster.nio.ObjectDataOutput;
import com.atlassian.nutcluster.nio.serialization.IdentifiedDataSerializable;
import com.atlassian.nutcluster.util.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;

public class GetInitialRaftGroupMembersIfCurrentGroupMemberOp
extends RaftOp
implements RaftNodeAware,
IndeterminateOperationStateAware,
IdentifiedDataSerializable {
    private Endpoint cpMember;
    private RaftNode raftNode;

    public GetInitialRaftGroupMembersIfCurrentGroupMemberOp() {
    }

    public GetInitialRaftGroupMembersIfCurrentGroupMemberOp(Endpoint cpMember) {
        this.cpMember = cpMember;
    }

    @Override
    public void setRaftNode(RaftNode raftNode) {
        this.raftNode = raftNode;
    }

    @Override
    public Object run(CPGroupId groupId, long commitIndex) {
        Preconditions.checkState(this.raftNode != null, "RaftNode is not injected in " + String.valueOf(groupId));
        Collection<Endpoint> members = this.raftNode.getAppliedMembers();
        Preconditions.checkState(members.contains(this.cpMember), String.valueOf(this.cpMember) + " is not in the current committed member list: " + String.valueOf(members) + " of " + String.valueOf(groupId));
        return new ArrayList<Endpoint>(this.raftNode.getInitialMembers());
    }

    @Override
    public boolean isRetryableOnIndeterminateOperationState() {
        return true;
    }

    @Override
    public int getFactoryId() {
        return RaftServiceDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 36;
    }

    @Override
    protected String getServiceName() {
        return "hz:core:raft";
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeObject(this.cpMember);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.cpMember = (Endpoint)in.readObject();
    }
}

