/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.cp.internal.raftop.metadata;

import com.atlassian.nutcluster.cp.CPGroupId;
import com.atlassian.nutcluster.cp.internal.IndeterminateOperationStateAware;
import com.atlassian.nutcluster.cp.internal.MetadataRaftGroupManager;
import com.atlassian.nutcluster.cp.internal.RaftServiceDataSerializerHook;
import com.atlassian.nutcluster.cp.internal.raftop.metadata.MetadataRaftGroupOp;
import com.atlassian.nutcluster.nio.ObjectDataInput;
import com.atlassian.nutcluster.nio.ObjectDataOutput;
import com.atlassian.nutcluster.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public class CompleteDestroyRaftGroupsOp
extends MetadataRaftGroupOp
implements IndeterminateOperationStateAware,
IdentifiedDataSerializable {
    private Set<CPGroupId> groupIds;

    public CompleteDestroyRaftGroupsOp() {
    }

    public CompleteDestroyRaftGroupsOp(Set<CPGroupId> groupIds) {
        this.groupIds = groupIds;
    }

    @Override
    public Object run(MetadataRaftGroupManager metadataGroupManager, long commitIndex) {
        metadataGroupManager.completeDestroyRaftGroups(this.groupIds);
        return null;
    }

    @Override
    public boolean isRetryableOnIndeterminateOperationState() {
        return true;
    }

    @Override
    public int getFactoryId() {
        return RaftServiceDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 15;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeInt(this.groupIds.size());
        for (CPGroupId groupId : this.groupIds) {
            out.writeObject(groupId);
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        int count = in.readInt();
        this.groupIds = new HashSet<CPGroupId>();
        for (int i = 0; i < count; ++i) {
            CPGroupId groupId = (CPGroupId)in.readObject();
            this.groupIds.add(groupId);
        }
    }

    @Override
    protected void toString(StringBuilder sb) {
        sb.append(", groupIds=").append(this.groupIds);
    }
}

