/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.instance;

import com.atlassian.nutcluster.core.LifecycleEvent;
import com.atlassian.nutcluster.core.LifecycleListener;
import com.atlassian.nutcluster.core.LifecycleService;
import com.atlassian.nutcluster.instance.Node;
import com.atlassian.nutcluster.instance.NutclusterInstanceFactory;
import com.atlassian.nutcluster.instance.NutclusterInstanceImpl;
import com.atlassian.nutcluster.internal.jmx.ManagementService;
import com.atlassian.nutcluster.logging.ILogger;
import com.atlassian.nutcluster.spi.annotation.PrivateApi;
import com.atlassian.nutcluster.util.UuidUtil;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

@PrivateApi
public class LifecycleServiceImpl
implements LifecycleService {
    private final NutclusterInstanceImpl instance;
    private final ConcurrentMap<String, LifecycleListener> lifecycleListeners = new ConcurrentHashMap<String, LifecycleListener>();
    private final Object lifecycleLock = new Object();

    public LifecycleServiceImpl(NutclusterInstanceImpl instance) {
        this.instance = instance;
    }

    private ILogger getLogger() {
        return this.instance.node.getLogger(LifecycleService.class.getName());
    }

    @Override
    public String addLifecycleListener(LifecycleListener lifecycleListener) {
        String id = UuidUtil.newUnsecureUuidString();
        this.lifecycleListeners.put(id, lifecycleListener);
        return id;
    }

    @Override
    public boolean removeLifecycleListener(String registrationId) {
        return this.lifecycleListeners.remove(registrationId) != null;
    }

    public void fireLifecycleEvent(LifecycleEvent.LifecycleState lifecycleState) {
        this.fireLifecycleEvent(new LifecycleEvent(lifecycleState));
    }

    public void fireLifecycleEvent(LifecycleEvent lifecycleEvent) {
        this.getLogger().info(String.valueOf(this.instance.node.getThisAddress()) + " is " + String.valueOf((Object)lifecycleEvent.getState()));
        for (LifecycleListener lifecycleListener : this.lifecycleListeners.values()) {
            lifecycleListener.stateChanged(lifecycleEvent);
        }
    }

    @Override
    public boolean isRunning() {
        return this.instance.node.isRunning();
    }

    @Override
    public void shutdown() {
        this.shutdown(false);
    }

    @Override
    public void terminate() {
        this.shutdown(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdown(boolean terminate) {
        Object object = this.lifecycleLock;
        synchronized (object) {
            Node node;
            this.fireLifecycleEvent(LifecycleEvent.LifecycleState.SHUTTING_DOWN);
            ManagementService managementService = this.instance.managementService;
            if (managementService != null) {
                managementService.destroy();
            }
            if ((node = this.instance.node) != null) {
                node.shutdown(terminate);
            }
            NutclusterInstanceFactory.remove(this.instance);
            this.fireLifecycleEvent(LifecycleEvent.LifecycleState.SHUTDOWN);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runUnderLifecycleLock(Runnable runnable) {
        Object object = this.lifecycleLock;
        synchronized (object) {
            runnable.run();
        }
    }
}

