/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.instance;

import com.atlassian.nutcluster.core.NutclusterException;
import com.atlassian.nutcluster.instance.DefaultNodeExtension;
import com.atlassian.nutcluster.instance.Node;
import com.atlassian.nutcluster.instance.NodeExtension;
import com.atlassian.nutcluster.logging.Logger;
import com.atlassian.nutcluster.spi.annotation.PrivateApi;
import com.atlassian.nutcluster.util.ExceptionUtil;
import com.atlassian.nutcluster.util.ServiceLoader;
import java.util.Iterator;
import java.util.List;

@PrivateApi
public final class NodeExtensionFactory {
    private static final String NODE_EXTENSION_FACTORY_ID = "com.atlassian.nutcluster.instance.NodeExtension";

    private NodeExtensionFactory() {
    }

    public static NodeExtension create(Node node, List<String> extensionPriorityList) {
        try {
            ClassLoader classLoader = node.getConfigClassLoader();
            Class<NodeExtension> chosenExtension = null;
            int chosenPriority = Integer.MAX_VALUE;
            Iterator<Class<NodeExtension>> iter = ServiceLoader.classIterator(NodeExtension.class, NODE_EXTENSION_FACTORY_ID, classLoader);
            while (iter.hasNext()) {
                Class<NodeExtension> currExt = iter.next();
                NodeExtensionFactory.warnIfDuplicate(currExt);
                int currPriority = extensionPriorityList.indexOf(currExt.getName());
                if (currPriority == -1 || currPriority >= chosenPriority) continue;
                chosenPriority = currPriority;
                chosenExtension = currExt;
            }
            if (chosenExtension == null) {
                throw new NutclusterException("ServiceLoader didn't find any services registered under com.atlassian.nutcluster.instance.NodeExtension");
            }
            return (NodeExtension)chosenExtension.getConstructor(Node.class).newInstance(node);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    private static void warnIfDuplicate(Class<NodeExtension> klass) {
        if (!klass.equals(DefaultNodeExtension.class) && klass.getName().equals(DefaultNodeExtension.class.getName())) {
            Logger.getLogger(NodeExtensionFactory.class).warning("DefaultNodeExtension class has been loaded by two different class-loaders.\nClassloader 1: " + String.valueOf(NodeExtensionFactory.class.getClassLoader()) + "\nClassloader 2: " + String.valueOf(klass.getClassLoader()) + "\nAre you running Nutcluster Jet in an OSGi environment? If so, set the bundle class-loader in the Config using the setClassloader() method");
        }
    }
}

