/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.instance;

import com.atlassian.nutcluster.cardinality.CardinalityEstimator;
import com.atlassian.nutcluster.config.Config;
import com.atlassian.nutcluster.core.ClientService;
import com.atlassian.nutcluster.core.Cluster;
import com.atlassian.nutcluster.core.DistributedObject;
import com.atlassian.nutcluster.core.DistributedObjectListener;
import com.atlassian.nutcluster.core.IAtomicLong;
import com.atlassian.nutcluster.core.IAtomicReference;
import com.atlassian.nutcluster.core.ICacheManager;
import com.atlassian.nutcluster.core.ICountDownLatch;
import com.atlassian.nutcluster.core.IExecutorService;
import com.atlassian.nutcluster.core.IList;
import com.atlassian.nutcluster.core.ILock;
import com.atlassian.nutcluster.core.IMap;
import com.atlassian.nutcluster.core.IQueue;
import com.atlassian.nutcluster.core.ISemaphore;
import com.atlassian.nutcluster.core.ISet;
import com.atlassian.nutcluster.core.ITopic;
import com.atlassian.nutcluster.core.IdGenerator;
import com.atlassian.nutcluster.core.LifecycleService;
import com.atlassian.nutcluster.core.Member;
import com.atlassian.nutcluster.core.MultiMap;
import com.atlassian.nutcluster.core.NutclusterInstance;
import com.atlassian.nutcluster.core.NutclusterInstanceNotActiveException;
import com.atlassian.nutcluster.core.PartitionService;
import com.atlassian.nutcluster.core.ReplicatedMap;
import com.atlassian.nutcluster.cp.CPSubsystem;
import com.atlassian.nutcluster.crdt.pncounter.PNCounter;
import com.atlassian.nutcluster.durableexecutor.DurableExecutorService;
import com.atlassian.nutcluster.flakeidgen.FlakeIdGenerator;
import com.atlassian.nutcluster.instance.NutclusterInstanceImpl;
import com.atlassian.nutcluster.instance.TerminatedLifecycleService;
import com.atlassian.nutcluster.internal.serialization.InternalSerializationService;
import com.atlassian.nutcluster.logging.LoggingService;
import com.atlassian.nutcluster.mapreduce.JobTracker;
import com.atlassian.nutcluster.quorum.QuorumService;
import com.atlassian.nutcluster.ringbuffer.Ringbuffer;
import com.atlassian.nutcluster.scheduledexecutor.IScheduledExecutorService;
import com.atlassian.nutcluster.spi.annotation.PrivateApi;
import com.atlassian.nutcluster.spi.impl.SerializationServiceSupport;
import com.atlassian.nutcluster.transaction.NutclusterXAResource;
import com.atlassian.nutcluster.transaction.TransactionContext;
import com.atlassian.nutcluster.transaction.TransactionException;
import com.atlassian.nutcluster.transaction.TransactionOptions;
import com.atlassian.nutcluster.transaction.TransactionalTask;
import java.util.Collection;
import java.util.concurrent.ConcurrentMap;

@PrivateApi
public final class NutclusterInstanceProxy
implements NutclusterInstance,
SerializationServiceSupport {
    protected volatile NutclusterInstanceImpl original;
    private final String name;

    protected NutclusterInstanceProxy(NutclusterInstanceImpl original) {
        this.original = original;
        this.name = original.getName();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public <K, V> IMap<K, V> getMap(String name) {
        return this.getOriginal().getMap(name);
    }

    @Override
    public <E> IQueue<E> getQueue(String name) {
        return this.getOriginal().getQueue(name);
    }

    @Override
    public <E> ITopic<E> getTopic(String name) {
        return this.getOriginal().getTopic(name);
    }

    @Override
    public <E> ITopic<E> getReliableTopic(String name) {
        return this.getOriginal().getReliableTopic(name);
    }

    @Override
    public <E> ISet<E> getSet(String name) {
        return this.getOriginal().getSet(name);
    }

    @Override
    public <E> IList<E> getList(String name) {
        return this.getOriginal().getList(name);
    }

    @Override
    public <K, V> MultiMap<K, V> getMultiMap(String name) {
        return this.getOriginal().getMultiMap(name);
    }

    @Override
    public JobTracker getJobTracker(String name) {
        return this.getOriginal().getJobTracker(name);
    }

    @Override
    public <E> Ringbuffer<E> getRingbuffer(String name) {
        return this.getOriginal().getRingbuffer(name);
    }

    @Override
    public ILock getLock(String key) {
        return this.getOriginal().getLock(key);
    }

    @Override
    public IExecutorService getExecutorService(String name) {
        return this.getOriginal().getExecutorService(name);
    }

    @Override
    public DurableExecutorService getDurableExecutorService(String name) {
        return this.getOriginal().getDurableExecutorService(name);
    }

    @Override
    public <T> T executeTransaction(TransactionalTask<T> task) throws TransactionException {
        return this.getOriginal().executeTransaction(task);
    }

    @Override
    public <T> T executeTransaction(TransactionOptions options, TransactionalTask<T> task) throws TransactionException {
        return this.getOriginal().executeTransaction(options, task);
    }

    @Override
    public TransactionContext newTransactionContext() {
        return this.getOriginal().newTransactionContext();
    }

    @Override
    public TransactionContext newTransactionContext(TransactionOptions options) {
        return this.getOriginal().newTransactionContext(options);
    }

    @Override
    public IdGenerator getIdGenerator(String name) {
        return this.getOriginal().getIdGenerator(name);
    }

    @Override
    public FlakeIdGenerator getFlakeIdGenerator(String name) {
        return this.getOriginal().getFlakeIdGenerator(name);
    }

    @Override
    public IAtomicLong getAtomicLong(String name) {
        return this.getOriginal().getAtomicLong(name);
    }

    @Override
    public <K, V> ReplicatedMap<K, V> getReplicatedMap(String name) {
        return this.getOriginal().getReplicatedMap(name);
    }

    @Override
    public <E> IAtomicReference<E> getAtomicReference(String name) {
        return this.getOriginal().getAtomicReference(name);
    }

    @Override
    public ICountDownLatch getCountDownLatch(String name) {
        return this.getOriginal().getCountDownLatch(name);
    }

    @Override
    public ISemaphore getSemaphore(String name) {
        return this.getOriginal().getSemaphore(name);
    }

    @Override
    public ICacheManager getCacheManager() {
        return this.getOriginal().getCacheManager();
    }

    @Override
    public Cluster getCluster() {
        return this.getOriginal().getCluster();
    }

    @Override
    public Member getLocalEndpoint() {
        return this.getOriginal().getLocalEndpoint();
    }

    @Override
    public Collection<DistributedObject> getDistributedObjects() {
        return this.getOriginal().getDistributedObjects();
    }

    @Override
    public Config getConfig() {
        return this.getOriginal().getConfig();
    }

    @Override
    public PartitionService getPartitionService() {
        return this.getOriginal().getPartitionService();
    }

    @Override
    public QuorumService getQuorumService() {
        return this.getOriginal().getQuorumService();
    }

    @Override
    public ClientService getClientService() {
        return this.getOriginal().getClientService();
    }

    @Override
    public LoggingService getLoggingService() {
        return this.getOriginal().getLoggingService();
    }

    @Override
    public LifecycleService getLifecycleService() {
        NutclusterInstanceImpl hz = this.original;
        return hz != null ? hz.getLifecycleService() : new TerminatedLifecycleService();
    }

    @Override
    public <T extends DistributedObject> T getDistributedObject(String serviceName, String name) {
        return this.getOriginal().getDistributedObject(serviceName, name);
    }

    @Override
    public String addDistributedObjectListener(DistributedObjectListener distributedObjectListener) {
        return this.getOriginal().addDistributedObjectListener(distributedObjectListener);
    }

    @Override
    public boolean removeDistributedObjectListener(String registrationId) {
        return this.getOriginal().removeDistributedObjectListener(registrationId);
    }

    @Override
    public ConcurrentMap<String, Object> getUserContext() {
        return this.getOriginal().getUserContext();
    }

    @Override
    public NutclusterXAResource getXAResource() {
        return this.getOriginal().getXAResource();
    }

    @Override
    public CardinalityEstimator getCardinalityEstimator(String name) {
        return this.getOriginal().getCardinalityEstimator(name);
    }

    @Override
    public PNCounter getPNCounter(String name) {
        return this.getOriginal().getPNCounter(name);
    }

    @Override
    public IScheduledExecutorService getScheduledExecutorService(String name) {
        return this.getOriginal().getScheduledExecutorService(name);
    }

    @Override
    public CPSubsystem getCPSubsystem() {
        return this.getOriginal().getCPSubsystem();
    }

    @Override
    public void shutdown() {
        this.getLifecycleService().shutdown();
    }

    @Override
    public InternalSerializationService getSerializationService() {
        return this.getOriginal().getSerializationService();
    }

    public NutclusterInstanceImpl getOriginal() {
        NutclusterInstanceImpl NutclusterInstance2 = this.original;
        if (NutclusterInstance2 == null) {
            throw new NutclusterInstanceNotActiveException();
        }
        return NutclusterInstance2;
    }

    public String toString() {
        NutclusterInstanceImpl NutclusterInstance2 = this.original;
        if (NutclusterInstance2 != null) {
            return NutclusterInstance2.toString();
        }
        return "NutclusterInstance {NOT ACTIVE}";
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof NutclusterInstance)) {
            return false;
        }
        NutclusterInstance that = (NutclusterInstance)o;
        return !(this.name == null ? that.getName() != null : !this.name.equals(that.getName()));
    }
}

