/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.internal.cluster.impl;

import com.atlassian.nutcluster.cluster.ClusterState;
import com.atlassian.nutcluster.cluster.Joiner;
import com.atlassian.nutcluster.instance.Node;
import com.atlassian.nutcluster.internal.cluster.impl.ClusterJoinManager;
import com.atlassian.nutcluster.internal.cluster.impl.ClusterServiceImpl;
import java.util.concurrent.atomic.AtomicBoolean;

final class SplitBrainHandler
implements Runnable {
    private final Node node;
    private final AtomicBoolean inProgress = new AtomicBoolean(false);

    public SplitBrainHandler(Node node) {
        this.node = node;
    }

    @Override
    public void run() {
        if (!this.shouldRun()) {
            return;
        }
        if (this.inProgress.compareAndSet(false, true)) {
            try {
                this.searchForOtherClusters();
            }
            finally {
                this.inProgress.set(false);
            }
        }
    }

    private boolean shouldRun() {
        ClusterServiceImpl clusterService = this.node.getClusterService();
        if (!clusterService.isJoined()) {
            return false;
        }
        if (!clusterService.isMaster()) {
            return false;
        }
        if (!this.node.isRunning()) {
            return false;
        }
        ClusterJoinManager clusterJoinManager = clusterService.getClusterJoinManager();
        if (clusterJoinManager.isJoinInProgress()) {
            return false;
        }
        ClusterState clusterState = clusterService.getClusterState();
        return clusterState.isJoinAllowed();
    }

    private void searchForOtherClusters() {
        Joiner joiner = this.node.getJoiner();
        if (joiner != null) {
            joiner.searchForOtherClusters();
        }
    }
}

