/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.internal.cluster.impl.operations;

import com.atlassian.nutcluster.cluster.Joiner;
import com.atlassian.nutcluster.cluster.impl.TcpIpJoiner;
import com.atlassian.nutcluster.instance.Node;
import com.atlassian.nutcluster.internal.cluster.impl.ClusterServiceImpl;
import com.atlassian.nutcluster.internal.cluster.impl.operations.AbstractJoinOperation;
import com.atlassian.nutcluster.logging.ILogger;
import com.atlassian.nutcluster.nio.Address;
import com.atlassian.nutcluster.spi.impl.NodeEngineImpl;

public class JoinMastershipClaimOp
extends AbstractJoinOperation {
    private transient boolean approvedAsMaster;

    @Override
    public void run() {
        NodeEngineImpl nodeEngine = (NodeEngineImpl)this.getNodeEngine();
        Node node = nodeEngine.getNode();
        Joiner joiner = node.getJoiner();
        ClusterServiceImpl clusterService = node.getClusterService();
        ILogger logger = node.getLogger(this.getClass().getName());
        if (joiner instanceof TcpIpJoiner) {
            TcpIpJoiner tcpIpJoiner = (TcpIpJoiner)joiner;
            Address endpoint = this.getCallerAddress();
            Address masterAddress = clusterService.getMasterAddress();
            this.approvedAsMaster = !tcpIpJoiner.isClaimingMastership() && !clusterService.isMaster() && (masterAddress == null || masterAddress.equals(endpoint));
        } else {
            this.approvedAsMaster = false;
            logger.warning("This node requires MulticastJoin strategy!");
        }
        if (logger.isFineEnabled()) {
            logger.fine("Sending '" + this.approvedAsMaster + "' for master claim of node: " + String.valueOf(this.getCallerAddress()));
        }
    }

    @Override
    public Object getResponse() {
        return this.approvedAsMaster;
    }

    @Override
    public int getId() {
        return 16;
    }
}

