/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.internal.cluster.impl.operations;

import com.atlassian.nutcluster.instance.Node;
import com.atlassian.nutcluster.internal.cluster.impl.ClusterServiceImpl;
import com.atlassian.nutcluster.internal.cluster.impl.operations.AbstractClusterOperation;
import com.atlassian.nutcluster.logging.ILogger;
import com.atlassian.nutcluster.nio.Address;
import com.atlassian.nutcluster.nio.ObjectDataInput;
import com.atlassian.nutcluster.nio.ObjectDataOutput;
import com.atlassian.nutcluster.spi.impl.NodeEngineImpl;
import java.io.IOException;

public class MergeClustersOp
extends AbstractClusterOperation {
    private Address newTargetAddress;

    public MergeClustersOp() {
    }

    public MergeClustersOp(Address newTargetAddress) {
        this.newTargetAddress = newTargetAddress;
    }

    @Override
    public void run() {
        boolean local;
        Address caller = this.getCallerAddress();
        NodeEngineImpl nodeEngine = (NodeEngineImpl)this.getNodeEngine();
        Node node = nodeEngine.getNode();
        final ClusterServiceImpl clusterService = node.getClusterService();
        Address masterAddress = clusterService.getMasterAddress();
        ILogger logger = node.loggingService.getLogger(this.getClass().getName());
        boolean bl = local = caller == null;
        if (!local && !caller.equals(masterAddress)) {
            logger.warning("Ignoring merge instruction sent from non-master endpoint: " + String.valueOf(caller));
            return;
        }
        logger.warning(String.valueOf(node.getThisAddress()) + " is merging to " + String.valueOf(this.newTargetAddress) + ", because: instructed by master " + String.valueOf(masterAddress));
        nodeEngine.getExecutionService().execute("hz:cluster:splitbrain", new Runnable(){

            @Override
            public void run() {
                clusterService.merge(MergeClustersOp.this.newTargetAddress);
            }
        });
    }

    @Override
    public boolean returnsResponse() {
        return true;
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        this.newTargetAddress = new Address();
        this.newTargetAddress.readData(in);
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        this.newTargetAddress.writeData(out);
    }

    @Override
    public int getId() {
        return 21;
    }
}

