/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.internal.diagnostics;

import com.atlassian.nutcluster.internal.diagnostics.DiagnosticsLogWriter;
import com.atlassian.nutcluster.internal.diagnostics.DiagnosticsPlugin;
import com.atlassian.nutcluster.logging.ILogger;
import com.atlassian.nutcluster.spi.impl.NodeEngineImpl;
import com.atlassian.nutcluster.spi.properties.NutclusterProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ConfigPropertiesPlugin
extends DiagnosticsPlugin {
    private final NutclusterProperties properties;
    private final List<String> keyList = new ArrayList<String>();

    public ConfigPropertiesPlugin(NodeEngineImpl nodeEngine) {
        this(nodeEngine.getLogger(ConfigPropertiesPlugin.class), nodeEngine.getProperties());
    }

    public ConfigPropertiesPlugin(ILogger logger, NutclusterProperties properties) {
        super(logger);
        this.properties = properties;
    }

    @Override
    public void onStart() {
        this.logger.info("Plugin:active");
    }

    @Override
    public long getPeriodMillis() {
        return -1L;
    }

    @Override
    public void run(DiagnosticsLogWriter writer) {
        this.keyList.clear();
        this.keyList.addAll(this.properties.keySet());
        Collections.sort(this.keyList);
        writer.startSection("ConfigProperties");
        for (String key : this.keyList) {
            String value = this.properties.get(key);
            writer.writeKeyValueEntry(key, value);
        }
        writer.endSection();
    }
}

