/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.internal.dynamicconfig.search;

import com.atlassian.nutcluster.config.Config;
import com.atlassian.nutcluster.config.ConfigPatternMatcher;
import com.atlassian.nutcluster.internal.config.ConfigUtils;
import com.atlassian.nutcluster.internal.dynamicconfig.ConfigurationService;
import com.atlassian.nutcluster.internal.dynamicconfig.search.ConfigSupplier;
import com.atlassian.nutcluster.internal.dynamicconfig.search.Searcher;
import com.atlassian.nutcluster.nio.serialization.IdentifiedDataSerializable;
import com.atlassian.nutcluster.partition.strategy.StringPartitioningStrategy;
import java.util.Map;
import javax.annotation.Nonnull;

class DynamicFirstSearcher<T extends IdentifiedDataSerializable>
implements Searcher<T> {
    private final ConfigurationService configurationService;
    private final Config staticConfig;
    private final ConfigPatternMatcher configPatternMatcher;

    DynamicFirstSearcher(ConfigurationService configurationService, Config statisticConfig, ConfigPatternMatcher configPatternMatcher) {
        this.configurationService = configurationService;
        this.staticConfig = statisticConfig;
        this.configPatternMatcher = configPatternMatcher;
    }

    @Override
    public T getConfig(@Nonnull String name, String fallbackName, @Nonnull ConfigSupplier<T> configSupplier) {
        String baseName = StringPartitioningStrategy.getBaseName(name);
        Map<String, T> staticCacheConfigs = configSupplier.getStaticConfigs(this.staticConfig);
        Object config = configSupplier.getDynamicConfig(this.configurationService, baseName);
        if (config == null) {
            config = (IdentifiedDataSerializable)ConfigUtils.lookupByPattern(this.configPatternMatcher, staticCacheConfigs, baseName);
        }
        if (config == null) {
            config = configSupplier.getStaticConfig(this.staticConfig, fallbackName);
        }
        return config;
    }
}

