/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.internal.eviction;

import com.atlassian.nutcluster.config.EvictionPolicy;
import com.atlassian.nutcluster.internal.eviction.Evictable;
import com.atlassian.nutcluster.internal.eviction.EvictionConfiguration;
import com.atlassian.nutcluster.internal.eviction.EvictionPolicyComparator;
import com.atlassian.nutcluster.internal.eviction.impl.comparator.LFUEvictionPolicyComparator;
import com.atlassian.nutcluster.internal.eviction.impl.comparator.LRUEvictionPolicyComparator;
import com.atlassian.nutcluster.internal.eviction.impl.comparator.RandomEvictionPolicyComparator;
import com.atlassian.nutcluster.internal.eviction.impl.evaluator.EvictionPolicyEvaluator;
import com.atlassian.nutcluster.nio.ClassLoaderUtil;
import com.atlassian.nutcluster.util.ExceptionUtil;
import com.atlassian.nutcluster.util.Preconditions;
import com.atlassian.nutcluster.util.StringUtil;

public final class EvictionPolicyEvaluatorProvider {
    private EvictionPolicyEvaluatorProvider() {
    }

    private static EvictionPolicyComparator createEvictionPolicyComparator(EvictionPolicy evictionPolicy) {
        switch (evictionPolicy) {
            case LRU: {
                return new LRUEvictionPolicyComparator();
            }
            case LFU: {
                return new LFUEvictionPolicyComparator();
            }
            case RANDOM: {
                return new RandomEvictionPolicyComparator();
            }
            case NONE: {
                return null;
            }
        }
        throw new IllegalArgumentException("Unsupported eviction policy: " + String.valueOf((Object)evictionPolicy));
    }

    public static <A, E extends Evictable> EvictionPolicyEvaluator<A, E> getEvictionPolicyEvaluator(EvictionConfiguration evictionConfig, ClassLoader classLoader) {
        EvictionPolicyComparator evictionPolicyComparator;
        Preconditions.checkNotNull(evictionConfig);
        String evictionPolicyComparatorClassName = evictionConfig.getComparatorClassName();
        if (!StringUtil.isNullOrEmpty(evictionPolicyComparatorClassName)) {
            try {
                evictionPolicyComparator = (EvictionPolicyComparator)ClassLoaderUtil.newInstance(classLoader, evictionPolicyComparatorClassName);
            }
            catch (Exception e) {
                throw ExceptionUtil.rethrow(e);
            }
        } else {
            EvictionPolicyComparator comparator = evictionConfig.getComparator();
            evictionPolicyComparator = comparator != null ? comparator : EvictionPolicyEvaluatorProvider.createEvictionPolicyComparator(evictionConfig.getEvictionPolicy());
        }
        return new EvictionPolicyEvaluator(evictionPolicyComparator);
    }
}

