/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.nutcluster.internal.jmx;

import com.atlassian.nutcluster.core.NutclusterInstance;
import com.atlassian.nutcluster.internal.jmx.ManagedAnnotation;
import com.atlassian.nutcluster.internal.jmx.ManagedDescription;
import com.atlassian.nutcluster.internal.jmx.ManagementService;
import com.atlassian.nutcluster.internal.jmx.NutclusterMBean;
import com.atlassian.nutcluster.spi.EventService;
import java.util.Hashtable;

@ManagedDescription(value="NutclusterInstance.EventService")
public class EventServiceMBean
extends NutclusterMBean<EventService> {
    private static final int INITIAL_CAPACITY = 5;

    public EventServiceMBean(NutclusterInstance NutclusterInstance2, EventService eventService, ManagementService service) {
        super(eventService, service);
        Hashtable<String, String> properties = new Hashtable<String, String>(5);
        properties.put("type", ManagementService.quote("NutclusterInstance.EventService"));
        properties.put("name", ManagementService.quote(NutclusterInstance2.getName()));
        properties.put("instance", ManagementService.quote(NutclusterInstance2.getName()));
        this.setObjectName(properties);
    }

    @ManagedAnnotation(value="eventThreadCount")
    @ManagedDescription(value="The event thread count")
    public int getEventThreadCount() {
        return ((EventService)this.managedObject).getEventThreadCount();
    }

    @ManagedAnnotation(value="eventQueueCapacity")
    @ManagedDescription(value="The event queue capacity")
    public int getEventQueueCapacity() {
        return ((EventService)this.managedObject).getEventQueueCapacity();
    }

    @ManagedAnnotation(value="eventQueueSize")
    @ManagedDescription(value="The size of the event queue")
    public int getEventQueueSize() {
        return ((EventService)this.managedObject).getEventQueueSize();
    }
}

